/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit;

import com.google.common.util.concurrent.Monitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Worker;
import nl.javadude.scannit.registry.Registry;
import nl.javadude.scannit.registry.RegistryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scannit {
    private static final AtomicReference<Scannit> REF = new AtomicReference();
    private static final Monitor M = new Monitor();
    final Registry registry = new Registry();
    private RegistryHelper registryHelper;
    private static final Logger logger = LoggerFactory.getLogger(Scannit.class);

    public Scannit(Configuration configuration) {
        configuration.wireScanners();
        new Worker(configuration, this.registry).scan();
        this.registryHelper = new RegistryHelper(this.registry);
    }

    public static Scannit boot(Configuration configuration) {
        return Scannit.boot(configuration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Scannit boot(Configuration configuration, boolean force) {
        try {
            M.enter();
            if (force || !Scannit.isBooted()) {
                REF.set(new Scannit(configuration));
            } else {
                logger.info("Not re-booting Scannit, because it was already booted.");
            }
            Scannit scannit = REF.get();
            return scannit;
        }
        finally {
            M.leave();
        }
    }

    public static boolean isBooted() {
        return REF.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(Scannit scannit) {
        try {
            M.enter();
            REF.set(scannit);
        }
        finally {
            M.leave();
        }
    }

    public static Scannit getInstance() {
        try {
            M.enter();
            if (REF.get() != null) {
                Scannit scannit = REF.get();
                return scannit;
            }
            throw new IllegalStateException("Scannit not set via setInstance(Scannit) or boot(Configuration)");
        }
        finally {
            M.leave();
        }
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.registryHelper.getTypesAnnotatedWith(annotation, true);
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.registryHelper.getMethodsAnnotatedWith(annotation);
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.registryHelper.getFieldsAnnotatedWith(annotation);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        return this.registryHelper.getSubTypesOf(clazz);
    }
}

