/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedRequestBuilder;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class CreateIndexRequestBuilder
extends AcknowledgedRequestBuilder<CreateIndexRequest, CreateIndexResponse, CreateIndexRequestBuilder, IndicesAdminClient> {
    public CreateIndexRequestBuilder(IndicesAdminClient indicesClient) {
        super(indicesClient, new CreateIndexRequest());
    }

    public CreateIndexRequestBuilder(IndicesAdminClient indicesClient, String index) {
        super(indicesClient, new CreateIndexRequest(index));
    }

    public CreateIndexRequestBuilder setIndex(String index) {
        ((CreateIndexRequest)this.request).index(index);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Settings settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Settings.Builder settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(XContentBuilder builder) {
        ((CreateIndexRequest)this.request).settings(builder);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(String source) {
        ((CreateIndexRequest)this.request).settings(source);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Object ... settings) {
        ((CreateIndexRequest)this.request).settings(settings);
        return this;
    }

    public CreateIndexRequestBuilder setSettings(Map<String, Object> source) {
        ((CreateIndexRequest)this.request).settings(source);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, String source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder setCause(String cause) {
        ((CreateIndexRequest)this.request).cause(cause);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, XContentBuilder source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, Map<String, Object> source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder addMapping(String type, Object ... source) {
        ((CreateIndexRequest)this.request).mapping(type, source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(Map source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(String source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(XContentBuilder source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder setAliases(BytesReference source) {
        ((CreateIndexRequest)this.request).aliases(source);
        return this;
    }

    public CreateIndexRequestBuilder addAlias(Alias alias) {
        ((CreateIndexRequest)this.request).alias(alias);
        return this;
    }

    public CreateIndexRequestBuilder setSource(String source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setSource(BytesReference source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setSource(byte[] source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder setSource(byte[] source, int offset, int length) {
        ((CreateIndexRequest)this.request).source(source, offset, length);
        return this;
    }

    public CreateIndexRequestBuilder setSource(Map<String, Object> source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    public CreateIndexRequestBuilder addCustom(IndexMetaData.Custom custom) {
        ((CreateIndexRequest)this.request).custom(custom);
        return this;
    }

    public CreateIndexRequestBuilder setSource(XContentBuilder source) {
        ((CreateIndexRequest)this.request).source(source);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<CreateIndexResponse> listener) {
        ((IndicesAdminClient)this.client).create((CreateIndexRequest)this.request, listener);
    }
}

