/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class GetFieldMappingsRequest
extends ActionRequest<GetFieldMappingsRequest> {
    protected boolean local = false;
    private String[] fields = Strings.EMPTY_ARRAY;
    private boolean includeDefaults = false;
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public GetFieldMappingsRequest() {
    }

    public GetFieldMappingsRequest(GetFieldMappingsRequest other) {
        this.local = other.local;
        this.includeDefaults = other.includeDefaults;
        this.indices = other.indices;
        this.types = other.types;
        this.indicesOptions = other.indicesOptions;
        this.fields = other.fields;
    }

    public GetFieldMappingsRequest local(boolean local) {
        this.local = local;
        return this;
    }

    public boolean local() {
        return this.local;
    }

    public GetFieldMappingsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public GetFieldMappingsRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public GetFieldMappingsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] types() {
        return this.types;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public GetFieldMappingsRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    public GetFieldMappingsRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        MasterNodeOperationRequest.DEFAULT_MASTER_NODE_TIMEOUT.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBoolean(this.local);
        out.writeStringArray(this.fields);
        out.writeBoolean(this.includeDefaults);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        TimeValue.readTimeValue(in);
        this.indices = in.readStringArray();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.local = in.readBoolean();
        this.fields = in.readStringArray();
        this.includeDefaults = in.readBoolean();
    }
}

