/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.util.Iterator;
import org.elasticsearch.action.admin.indices.status.DocsStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.shard.ShardId;

@Deprecated
public class IndexShardStatus
implements Iterable<ShardStatus> {
    private final ShardId shardId;
    private final ShardStatus[] shards;
    private transient DocsStatus docs;

    IndexShardStatus(ShardId shardId, ShardStatus[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public ShardStatus[] getShards() {
        return this.shards;
    }

    public ShardStatus getAt(int position) {
        return this.shards[position];
    }

    public ByteSizeValue getPrimaryStoreSize() {
        long bytes = -1L;
        for (ShardStatus shard : this.getShards()) {
            if (!shard.getShardRouting().primary() || shard.getStoreSize() == null) continue;
            if (bytes == -1L) {
                bytes = 0L;
            }
            bytes += shard.getStoreSize().bytes();
        }
        if (bytes == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes);
    }

    public ByteSizeValue getStoreSize() {
        long bytes = -1L;
        for (ShardStatus shard : this.getShards()) {
            if (shard.getStoreSize() == null) continue;
            if (bytes == -1L) {
                bytes = 0L;
            }
            bytes += shard.getStoreSize().bytes();
        }
        if (bytes == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes);
    }

    public long getTranslogOperations() {
        long translogOperations = -1L;
        for (ShardStatus shard : this.getShards()) {
            if (shard.getTranslogOperations() == -1L) continue;
            if (translogOperations == -1L) {
                translogOperations = 0L;
            }
            translogOperations += shard.getTranslogOperations();
        }
        return translogOperations;
    }

    public DocsStatus getDocs() {
        if (this.docs != null) {
            return this.docs;
        }
        DocsStatus docs = null;
        for (ShardStatus shard : this.getShards()) {
            if (!shard.getShardRouting().primary() || shard.getDocs() == null) continue;
            if (docs == null) {
                docs = new DocsStatus();
            }
            docs.numDocs += shard.getDocs().getNumDocs();
            docs.maxDoc += shard.getDocs().getMaxDoc();
            docs.deletedDocs += shard.getDocs().getDeletedDocs();
        }
        this.docs = docs;
        return this.docs;
    }

    public MergeStats getMergeStats() {
        MergeStats mergeStats = new MergeStats();
        for (ShardStatus shard : this.shards) {
            mergeStats.add(shard.getMergeStats());
        }
        return mergeStats;
    }

    public RefreshStats getRefreshStats() {
        RefreshStats refreshStats = new RefreshStats();
        for (ShardStatus shard : this.shards) {
            refreshStats.add(shard.getRefreshStats());
        }
        return refreshStats;
    }

    public FlushStats getFlushStats() {
        FlushStats flushStats = new FlushStats();
        for (ShardStatus shard : this.shards) {
            flushStats.add(shard.flushStats);
        }
        return flushStats;
    }

    @Override
    public Iterator<ShardStatus> iterator() {
        return Iterators.forArray(this.shards);
    }
}

