/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.put;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.put.PutIndexedScriptResponse;
import org.elasticsearch.action.support.DelegatingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutIndexedScriptAction
extends HandledTransportAction<PutIndexedScriptRequest, PutIndexedScriptResponse> {
    private ScriptService scriptService;
    private Client client;

    @Inject
    public TransportPutIndexedScriptAction(Settings settings, ThreadPool threadPool, ScriptService scriptService, Client client, TransportService transportService) {
        super(settings, "putIndexedScript", threadPool, transportService);
        this.client = client;
        this.scriptService = scriptService;
    }

    @Override
    public PutIndexedScriptRequest newRequestInstance() {
        return new PutIndexedScriptRequest();
    }

    @Override
    protected void doExecute(PutIndexedScriptRequest request, ActionListener<PutIndexedScriptResponse> listener) {
        this.scriptService.putScriptToIndex(this.client, request.safeSource(), request.scriptLang(), request.id(), null, request.opType().toString(), request.version(), request.versionType(), (ActionListener<IndexResponse>)new DelegatingActionListener<IndexResponse, PutIndexedScriptResponse>(listener){

            @Override
            public PutIndexedScriptResponse getDelegatedFromInstigator(IndexResponse indexResponse) {
                return new PutIndexedScriptResponse(indexResponse.getType(), indexResponse.getId(), indexResponse.getVersion(), indexResponse.isCreated());
            }
        });
    }
}

