/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.List;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Lookups;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.spi.InjectionListener;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.spi.TypeEncounter;

final class EncounterImpl<T>
implements TypeEncounter<T> {
    private final Errors errors;
    private final Lookups lookups;
    private List<MembersInjector<? super T>> membersInjectors;
    private List<InjectionListener<? super T>> injectionListeners;
    private boolean valid = true;

    public EncounterImpl(Errors errors, Lookups lookups) {
        this.errors = errors;
        this.lookups = lookups;
    }

    public void invalidate() {
        this.valid = false;
    }

    public ImmutableList<MembersInjector<? super T>> getMembersInjectors() {
        return this.membersInjectors == null ? ImmutableList.of() : ImmutableList.copyOf(this.membersInjectors);
    }

    public ImmutableList<InjectionListener<? super T>> getInjectionListeners() {
        return this.injectionListeners == null ? ImmutableList.of() : ImmutableList.copyOf(this.injectionListeners);
    }

    @Override
    public void register(MembersInjector<? super T> membersInjector) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        if (this.membersInjectors == null) {
            this.membersInjectors = Lists.newArrayList();
        }
        this.membersInjectors.add(membersInjector);
    }

    @Override
    public void register(InjectionListener<? super T> injectionListener) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        if (this.injectionListeners == null) {
            this.injectionListeners = Lists.newArrayList();
        }
        this.injectionListeners.add(injectionListener);
    }

    @Override
    public void addError(String message, Object ... arguments) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        this.errors.addMessage(message, arguments);
    }

    @Override
    public void addError(Throwable t) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        this.errors.errorInUserCode(t, "An exception was caught and reported. Message: %s", t.getMessage());
    }

    @Override
    public void addError(Message message) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        this.errors.addMessage(message);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        return this.lookups.getProvider(key);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        return this.lookups.getMembersInjector(typeLiteral);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.getMembersInjector(TypeLiteral.get(type));
    }
}

