/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping.unicast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.discovery.zen.DiscoveryNodesProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class UnicastZenPing
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    public static final int LIMIT_PORTS_COUNT = 1;
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterName clusterName;
    private final Version version;
    private final int concurrentConnects;
    private final DiscoveryNode[] nodes;
    private volatile DiscoveryNodesProvider nodesProvider;
    private final AtomicInteger pingIdGenerator = new AtomicInteger();
    private final Map<Integer, ConcurrentMap<DiscoveryNode, ZenPing.PingResponse>> receivedResponses = ConcurrentCollections.newConcurrentMap();
    private final Queue<ZenPing.PingResponse> temporalResponses = ConcurrentCollections.newQueue();
    private final CopyOnWriteArrayList<UnicastHostsProvider> hostsProviders = new CopyOnWriteArrayList();

    public UnicastZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, Version version, @Nullable Set<UnicastHostsProvider> unicastHostsProviders) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        this.version = version;
        if (unicastHostsProviders != null) {
            for (UnicastHostsProvider unicastHostsProvider : unicastHostsProviders) {
                this.addHostsProvider(unicastHostsProvider);
            }
        }
        this.concurrentConnects = this.componentSettings.getAsInt("concurrent_connects", (Integer)10);
        String[] hostArr = this.componentSettings.getAsArray("hosts");
        for (int i = 0; i < hostArr.length; ++i) {
            hostArr[i] = hostArr[i].trim();
        }
        ArrayList<String> hosts = Lists.newArrayList(hostArr);
        this.logger.debug("using initial hosts {}, with concurrent_connects [{}]", hosts, this.concurrentConnects);
        ArrayList<DiscoveryNode> nodes = Lists.newArrayList();
        int idCounter = 0;
        for (String host : hosts) {
            try {
                TransportAddress[] addresses = transportService.addressesFromString(host);
                for (int i = 0; i < addresses.length && i < 1; ++i) {
                    nodes.add(new DiscoveryNode("#zen_unicast_" + ++idCounter + "#", addresses[i], version));
                }
            }
            catch (Exception e) {
                throw new ElasticsearchIllegalArgumentException("Failed to resolve address for [" + host + "]", e);
            }
        }
        this.nodes = nodes.toArray(new DiscoveryNode[nodes.size()]);
        transportService.registerHandler("discovery/zen/unicast", new UnicastPingRequestHandler());
    }

    @Override
    protected void doStart() throws ElasticsearchException {
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        this.transportService.removeHandler("discovery/zen/unicast");
    }

    public void addHostsProvider(UnicastHostsProvider provider) {
        this.hostsProviders.add(provider);
    }

    public void removeHostsProvider(UnicastHostsProvider provider) {
        this.hostsProviders.remove(provider);
    }

    @Override
    public void setNodesProvider(DiscoveryNodesProvider nodesProvider) {
        this.nodesProvider = nodesProvider;
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void ping(final ZenPing.PingListener listener, final TimeValue timeout) throws ElasticsearchException {
        final SendPingsHandler sendPingsHandler = new SendPingsHandler(this.pingIdGenerator.incrementAndGet());
        this.receivedResponses.put(sendPingsHandler.id(), ConcurrentCollections.newConcurrentMap());
        this.sendPings(timeout, null, sendPingsHandler);
        this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "generic", new Runnable(){

            @Override
            public void run() {
                try {
                    UnicastZenPing.this.sendPings(timeout, null, sendPingsHandler);
                    UnicastZenPing.this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "generic", new Runnable(){

                        @Override
                        public void run() {
                            try {
                                UnicastZenPing.this.sendPings(timeout, TimeValue.timeValueMillis(timeout.millis() / 2L), sendPingsHandler);
                                ConcurrentMap responses = (ConcurrentMap)UnicastZenPing.this.receivedResponses.remove(sendPingsHandler.id());
                                sendPingsHandler.close();
                                for (DiscoveryNode node : sendPingsHandler.nodeToDisconnect) {
                                    UnicastZenPing.this.logger.trace("[{}] disconnecting from {}", sendPingsHandler.id(), node);
                                    UnicastZenPing.this.transportService.disconnectFromNode(node);
                                }
                                listener.onPing(responses.values().toArray(new ZenPing.PingResponse[responses.size()]));
                            }
                            catch (EsRejectedExecutionException ex) {
                                UnicastZenPing.this.logger.debug("Ping execution rejected", ex, new Object[0]);
                            }
                        }
                    });
                }
                catch (EsRejectedExecutionException ex) {
                    UnicastZenPing.this.logger.debug("Ping execution rejected", ex, new Object[0]);
                }
            }
        });
    }

    void sendPings(final TimeValue timeout, @Nullable TimeValue waitTime, final SendPingsHandler sendPingsHandler) {
        final UnicastPingRequest pingRequest = new UnicastPingRequest();
        pingRequest.id = sendPingsHandler.id();
        pingRequest.timeout = timeout;
        DiscoveryNodes discoNodes = this.nodesProvider.nodes();
        pingRequest.pingResponse = new ZenPing.PingResponse(discoNodes.localNode(), discoNodes.masterNode(), this.clusterName);
        HashSet<DiscoveryNode> nodesToPing = new HashSet<DiscoveryNode>(Arrays.asList(this.nodes));
        for (ZenPing.PingResponse temporalResponse : this.temporalResponses) {
            if (!this.clusterName.equals(temporalResponse.clusterName())) continue;
            nodesToPing.add(temporalResponse.target());
        }
        for (UnicastHostsProvider provider : this.hostsProviders) {
            nodesToPing.addAll(provider.buildDynamicNodes());
        }
        final CountDownLatch latch = new CountDownLatch(nodesToPing.size());
        for (final DiscoveryNode node : nodesToPing) {
            boolean nodeFoundByAddressX;
            DiscoveryNode nodeToSendX = discoNodes.findByAddress(node.address());
            if (nodeToSendX != null) {
                nodeFoundByAddressX = true;
            } else {
                nodeToSendX = node;
                nodeFoundByAddressX = false;
            }
            final DiscoveryNode nodeToSend = nodeToSendX;
            final boolean nodeFoundByAddress = nodeFoundByAddressX;
            if (!this.transportService.nodeConnected(nodeToSend)) {
                if (sendPingsHandler.isClosed()) {
                    return;
                }
                sendPingsHandler.nodeToDisconnect.add(nodeToSend);
                sendPingsHandler.executor().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (sendPingsHandler.isClosed()) {
                            return;
                        }
                        boolean success = false;
                        try {
                            if (!nodeFoundByAddress) {
                                UnicastZenPing.this.logger.trace("[{}] connecting (light) to {}", sendPingsHandler.id(), nodeToSend);
                                UnicastZenPing.this.transportService.connectToNodeLight(nodeToSend);
                            } else {
                                UnicastZenPing.this.logger.trace("[{}] connecting to {}", sendPingsHandler.id(), nodeToSend);
                                UnicastZenPing.this.transportService.connectToNode(nodeToSend);
                            }
                            UnicastZenPing.this.logger.trace("[{}] connected to {}", sendPingsHandler.id(), node);
                            if (UnicastZenPing.this.receivedResponses.containsKey(sendPingsHandler.id())) {
                                UnicastZenPing.this.sendPingRequestToNode(sendPingsHandler.id(), timeout, pingRequest, latch, node, nodeToSend);
                            } else {
                                latch.countDown();
                                UnicastZenPing.this.logger.trace("[{}] connect to {} was too long outside of ping window, bailing", sendPingsHandler.id(), node);
                            }
                            success = true;
                        }
                        catch (ConnectTransportException e) {
                            UnicastZenPing.this.logger.trace("[{}] failed to connect to {}", e, sendPingsHandler.id(), nodeToSend);
                        }
                        catch (Throwable e) {
                            UnicastZenPing.this.logger.warn("[{}] failed send ping to {}", e, sendPingsHandler.id(), nodeToSend);
                        }
                        finally {
                            if (!success) {
                                latch.countDown();
                            }
                        }
                    }
                });
                continue;
            }
            this.sendPingRequestToNode(sendPingsHandler.id(), timeout, pingRequest, latch, node, nodeToSend);
        }
        if (waitTime != null) {
            try {
                latch.await(waitTime.millis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private void sendPingRequestToNode(final int id, TimeValue timeout, UnicastPingRequest pingRequest, final CountDownLatch latch, final DiscoveryNode node, final DiscoveryNode nodeToSend) {
        this.logger.trace("[{}] sending to {}", id, nodeToSend);
        this.transportService.sendRequest(nodeToSend, "discovery/zen/unicast", pingRequest, TransportRequestOptions.options().withTimeout((long)((double)timeout.millis() * 1.25)), new BaseTransportResponseHandler<UnicastPingResponse>(){

            @Override
            public UnicastPingResponse newInstance() {
                return new UnicastPingResponse();
            }

            @Override
            public String executor() {
                return "same";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleResponse(UnicastPingResponse response) {
                UnicastZenPing.this.logger.trace("[{}] received response from {}: {}", id, nodeToSend, Arrays.toString(response.pingResponses));
                try {
                    DiscoveryNodes discoveryNodes = UnicastZenPing.this.nodesProvider.nodes();
                    for (ZenPing.PingResponse pingResponse : response.pingResponses) {
                        if (pingResponse.target().id().equals(discoveryNodes.localNodeId())) continue;
                        if (!pingResponse.clusterName().equals(UnicastZenPing.this.clusterName)) {
                            UnicastZenPing.this.logger.debug("[{}] filtering out response from {}, not same cluster_name [{}]", id, pingResponse.target(), pingResponse.clusterName().value());
                            continue;
                        }
                        ConcurrentMap responses = (ConcurrentMap)UnicastZenPing.this.receivedResponses.get(response.id);
                        if (responses == null) {
                            UnicastZenPing.this.logger.warn("received ping response {} with no matching id [{}]", pingResponse, response.id);
                            continue;
                        }
                        ZenPing.PingResponse existingResponse = (ZenPing.PingResponse)responses.get(pingResponse.target());
                        if (existingResponse == null) {
                            responses.put(pingResponse.target(), pingResponse);
                            continue;
                        }
                        if (pingResponse.master() == null) continue;
                        responses.put(pingResponse.target(), pingResponse);
                    }
                }
                finally {
                    latch.countDown();
                }
            }

            @Override
            public void handleException(TransportException exp) {
                latch.countDown();
                if (exp instanceof ConnectTransportException) {
                    UnicastZenPing.this.logger.trace("failed to connect to {}", exp, nodeToSend);
                } else {
                    UnicastZenPing.this.logger.warn("failed to send ping to [{}]", exp, node);
                }
            }
        });
    }

    private UnicastPingResponse handlePingRequest(final UnicastPingRequest request) {
        if (this.lifecycle.stoppedOrClosed()) {
            throw new ElasticsearchIllegalStateException("received ping request while stopped/closed");
        }
        this.temporalResponses.add(request.pingResponse);
        this.threadPool.schedule(TimeValue.timeValueMillis(request.timeout.millis() * 2L), "same", new Runnable(){

            @Override
            public void run() {
                UnicastZenPing.this.temporalResponses.remove(request.pingResponse);
            }
        });
        ArrayList<ZenPing.PingResponse> pingResponses = Lists.newArrayList(this.temporalResponses);
        DiscoveryNodes discoNodes = this.nodesProvider.nodes();
        pingResponses.add(new ZenPing.PingResponse(discoNodes.localNode(), discoNodes.masterNode(), this.clusterName));
        UnicastPingResponse unicastPingResponse = new UnicastPingResponse();
        unicastPingResponse.id = request.id;
        unicastPingResponse.pingResponses = pingResponses.toArray(new ZenPing.PingResponse[pingResponses.size()]);
        return unicastPingResponse;
    }

    static class UnicastPingResponse
    extends TransportResponse {
        int id;
        ZenPing.PingResponse[] pingResponses;

        UnicastPingResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readInt();
            this.pingResponses = new ZenPing.PingResponse[in.readVInt()];
            for (int i = 0; i < this.pingResponses.length; ++i) {
                this.pingResponses[i] = ZenPing.PingResponse.readPingResponse(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            out.writeVInt(this.pingResponses.length);
            for (ZenPing.PingResponse pingResponse : this.pingResponses) {
                pingResponse.writeTo(out);
            }
        }
    }

    static class UnicastPingRequest
    extends TransportRequest {
        int id;
        TimeValue timeout;
        ZenPing.PingResponse pingResponse;

        UnicastPingRequest() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readInt();
            this.timeout = TimeValue.readTimeValue(in);
            this.pingResponse = ZenPing.PingResponse.readPingResponse(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            this.timeout.writeTo(out);
            this.pingResponse.writeTo(out);
        }
    }

    class UnicastPingRequestHandler
    extends BaseTransportRequestHandler<UnicastPingRequest> {
        static final String ACTION = "discovery/zen/unicast";

        UnicastPingRequestHandler() {
        }

        @Override
        public UnicastPingRequest newInstance() {
            return new UnicastPingRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(UnicastPingRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(UnicastZenPing.this.handlePingRequest(request));
        }
    }

    class SendPingsHandler {
        private final int id;
        private volatile ExecutorService executor;
        private final Set<DiscoveryNode> nodeToDisconnect = ConcurrentCollections.newConcurrentSet();
        private volatile boolean closed;

        SendPingsHandler(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public Executor executor() {
            if (this.executor == null) {
                ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(UnicastZenPing.this.settings, "[unicast_connect]");
                this.executor = EsExecutors.newScaling(0, UnicastZenPing.this.concurrentConnects, 60L, TimeUnit.SECONDS, threadFactory);
            }
            return this.executor;
        }

        public void close() {
            this.closed = true;
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.executor = null;
            }
        }
    }
}

