/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;

public class BinaryDVAtomicFieldData
implements AtomicFieldData<ScriptDocValues.Strings> {
    private final AtomicReader reader;
    private final String field;

    public BinaryDVAtomicFieldData(AtomicReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    public long ramBytesUsed() {
        return -1L;
    }

    @Override
    public BytesValues getBytesValues() {
        try {
            final BinaryDocValues values = DocValues.getBinary((AtomicReader)this.reader, (String)this.field);
            final Bits docsWithField = DocValues.getDocsWithField((AtomicReader)this.reader, (String)this.field);
            return new BytesValues(false){
                int docId;

                @Override
                public int setDocument(int docId) {
                    this.docId = docId;
                    return docsWithField.get(docId) ? 1 : 0;
                }

                @Override
                public BytesRef nextValue() {
                    return values.get(this.docId);
                }
            };
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    @Override
    public void close() {
    }
}

