/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class PagedBytesAtomicFieldData
implements AtomicFieldData.WithOrdinals<ScriptDocValues.Strings> {
    private final PagedBytes.Reader bytes;
    private final MonotonicAppendingLongBuffer termOrdToBytesOffset;
    protected final Ordinals ordinals;
    private long size = -1L;
    private final long readerBytesSize;

    public PagedBytesAtomicFieldData(PagedBytes.Reader bytes, long readerBytesSize, MonotonicAppendingLongBuffer termOrdToBytesOffset, Ordinals ordinals) {
        this.bytes = bytes;
        this.termOrdToBytesOffset = termOrdToBytesOffset;
        this.ordinals = ordinals;
        this.readerBytesSize = readerBytesSize;
    }

    @Override
    public void close() {
    }

    public long ramBytesUsed() {
        if (this.size == -1L) {
            long size = this.ordinals.ramBytesUsed();
            size += this.readerBytesSize;
            this.size = size += this.termOrdToBytesOffset.ramBytesUsed();
        }
        return this.size;
    }

    @Override
    public BytesValues.WithOrdinals getBytesValues() {
        return this.ordinals.ordinals(new ValuesHolder(this.bytes, this.termOrdToBytesOffset));
    }

    @Override
    public ScriptDocValues.Strings getScriptValues() {
        return new ScriptDocValues.Strings(this.getBytesValues());
    }

    private static class ValuesHolder
    implements Ordinals.ValuesHolder {
        private final BytesRef scratch = new BytesRef();
        private final PagedBytes.Reader bytes;
        private final MonotonicAppendingLongBuffer termOrdToBytesOffset;

        ValuesHolder(PagedBytes.Reader bytes, MonotonicAppendingLongBuffer termOrdToBytesOffset) {
            this.bytes = bytes;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            assert (ord != -1L);
            this.bytes.fill(this.scratch, this.termOrdToBytesOffset.get(ord));
            return this.scratch;
        }
    }
}

