/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.BytesValues;

abstract class SortedSetDVAtomicFieldData {
    private final AtomicReader reader;
    private final String field;
    private final boolean multiValued;
    private final long valueCount;

    SortedSetDVAtomicFieldData(AtomicReader reader, String field) {
        this.reader = reader;
        this.field = field;
        SortedSetDocValues dv = SortedSetDVAtomicFieldData.getValuesNoException(reader, field);
        this.multiValued = DocValues.unwrapSingleton((SortedSetDocValues)dv) == null;
        this.valueCount = dv.getValueCount();
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public long getNumberUniqueValues() {
        return this.valueCount;
    }

    public long ramBytesUsed() {
        return -1L;
    }

    public void close() {
    }

    public BytesValues.WithOrdinals getBytesValues() {
        SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
        if (values instanceof RandomAccessOrds) {
            return new RandomAccessSortedSetValues((RandomAccessOrds)values, this.multiValued);
        }
        return new SortedSetValues(values, this.multiValued);
    }

    public TermsEnum getTermsEnum() {
        return SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field).termsEnum();
    }

    private static SortedSetDocValues getValuesNoException(AtomicReader reader, String field) {
        try {
            return DocValues.getSortedSet((AtomicReader)reader, (String)field);
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Couldn't load doc values", e);
        }
    }

    private static final class SortedSetValues
    extends BytesValues.WithOrdinals {
        private final SortedSetDocValues values;
        private long[] ords;
        private int ordIndex = Integer.MAX_VALUE;

        SortedSetValues(SortedSetDocValues values, boolean multiValued) {
            super(multiValued);
            this.values = values;
            this.ords = new long[0];
        }

        @Override
        public long getMaxOrd() {
            return this.values.getValueCount();
        }

        @Override
        public long getOrd(int docId) {
            this.values.setDocument(docId);
            return this.values.nextOrd();
        }

        @Override
        public long nextOrd() {
            assert (this.ordIndex < this.ords.length);
            return this.ords[this.ordIndex++];
        }

        @Override
        public int setDocument(int docId) {
            this.values.setDocument(docId);
            int i = 0;
            long ord = this.values.nextOrd();
            while (ord != -1L) {
                this.ords = ArrayUtil.grow((long[])this.ords, (int)(i + 1));
                this.ords[i++] = ord;
                ord = this.values.nextOrd();
            }
            this.ordIndex = 0;
            return i;
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            return this.values.lookupOrd(ord);
        }
    }

    private static final class RandomAccessSortedSetValues
    extends BytesValues.WithOrdinals {
        private final RandomAccessOrds values;
        private int index = 0;

        RandomAccessSortedSetValues(RandomAccessOrds values, boolean multiValued) {
            super(multiValued);
            this.values = values;
        }

        @Override
        public long getMaxOrd() {
            return this.values.getValueCount();
        }

        @Override
        public long getOrd(int docId) {
            this.values.setDocument(docId);
            return this.values.nextOrd();
        }

        @Override
        public long nextOrd() {
            return this.values.ordAt(this.index++);
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            return this.values.lookupOrd(ord);
        }

        @Override
        public int setDocument(int docId) {
            this.values.setDocument(docId);
            this.index = 0;
            return this.values.cardinality();
        }
    }
}

