/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;

public class TypeParsers {
    public static final String MULTI_FIELD_CONTENT_TYPE = "multi_field";
    public static final Mapper.TypeParser multiFieldConverterTypeParser = new Mapper.TypeParser(){

        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            ContentPath.Type pathType = null;
            AbstractFieldMapper.Builder mainFieldBuilder = null;
            ArrayList<AbstractFieldMapper.Builder> fields = null;
            String firstType = null;
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("path")) {
                    pathType = TypeParsers.parsePathType(name, fieldNode.toString());
                    continue;
                }
                if (!fieldName.equals("fields")) continue;
                Map fieldsNode = (Map)fieldNode;
                for (Map.Entry entry1 : fieldsNode.entrySet()) {
                    String type;
                    String propName = (String)entry1.getKey();
                    Map propNode = (Map)entry1.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode != null) {
                        type = typeNode.toString();
                        if (firstType == null) {
                            firstType = type;
                        }
                    } else {
                        throw new MapperParsingException("No type specified for property [" + propName + "]");
                    }
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    if (propName.equals(name)) {
                        mainFieldBuilder = (AbstractFieldMapper.Builder)typeParser.parse(propName, propNode, parserContext);
                        continue;
                    }
                    if (fields == null) {
                        fields = new ArrayList<AbstractFieldMapper.Builder>(2);
                    }
                    fields.add((AbstractFieldMapper.Builder)typeParser.parse(propName, propNode, parserContext));
                }
            }
            if (mainFieldBuilder == null) {
                Mapper.Builder<?, ?> builder;
                if (fields == null) {
                    return new StringFieldMapper.Builder(name).index(false);
                }
                Mapper.TypeParser typeParser = parserContext.typeParser(firstType);
                mainFieldBuilder = typeParser == null ? new StringFieldMapper.Builder(name).index(false) : ((builder = typeParser.parse(name, Collections.emptyMap(), parserContext)) instanceof AbstractFieldMapper.Builder ? ((AbstractFieldMapper.Builder)builder).index(false) : new StringFieldMapper.Builder(name).index(false));
            }
            if (fields != null && pathType != null) {
                for (Mapper.Builder builder : fields) {
                    mainFieldBuilder.addMultiField(builder);
                }
                mainFieldBuilder.multiFieldPathType(pathType);
            } else if (fields != null) {
                for (Mapper.Builder builder : fields) {
                    mainFieldBuilder.addMultiField(builder);
                }
            } else if (pathType != null) {
                mainFieldBuilder.multiFieldPathType(pathType);
            }
            return mainFieldBuilder;
        }
    };
    public static final String DOC_VALUES = "doc_values";
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";
    public static final String INDEX_OPTIONS_OFFSETS = "offsets";

    public static void parseNumberField(NumberFieldMapper.Builder builder, String name, Map<String, Object> numberNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name, numberNode, parserContext);
        for (Map.Entry<String, Object> entry : numberNode.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (propName.equals("precision_step")) {
                builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                continue;
            }
            if (propName.equals("ignore_malformed")) {
                builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("coerce")) {
                builder.coerce(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("similarity")) {
                builder.similarity(parserContext.similarityLookupService().similarity(propNode.toString()));
                continue;
            }
            TypeParsers.parseMultiField(builder, name, numberNode, parserContext, propName, propNode);
        }
    }

    public static void parseField(AbstractFieldMapper.Builder builder, String name, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        for (Map.Entry<String, Object> entry : fieldNode.entrySet()) {
            NamedAnalyzer analyzer;
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (propName.equals("index_name")) {
                builder.indexName(propNode.toString());
                continue;
            }
            if (propName.equals("store")) {
                builder.store(TypeParsers.parseStore(name, propNode.toString()));
                continue;
            }
            if (propName.equals("index")) {
                TypeParsers.parseIndex(name, propNode.toString(), builder);
                continue;
            }
            if (propName.equals("tokenized")) {
                builder.tokenized(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals(DOC_VALUES)) {
                builder.docValues(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("term_vector")) {
                TypeParsers.parseTermVector(name, propNode.toString(), builder);
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vectors")) {
                builder.storeTermVectors(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vector_offsets")) {
                builder.storeTermVectorOffsets(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vector_positions")) {
                builder.storeTermVectorPositions(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("store_term_vector_payloads")) {
                builder.storeTermVectorPayloads(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("norms")) {
                Map<String, Object> properties = XContentMapValues.nodeMapValue(propNode, "norms");
                for (Map.Entry<String, Object> entry2 : properties.entrySet()) {
                    String propName2 = Strings.toUnderscoreCase(entry2.getKey());
                    Object propNode2 = entry2.getValue();
                    if (propName2.equals("enabled")) {
                        builder.omitNorms(!XContentMapValues.nodeBooleanValue(propNode2));
                        continue;
                    }
                    if (!propName2.equals("loading")) continue;
                    builder.normsLoading(FieldMapper.Loading.parse(XContentMapValues.nodeStringValue(propNode2, null), null));
                }
                continue;
            }
            if (propName.equals("omit_term_freq_and_positions")) {
                FieldInfo.IndexOptions op;
                FieldInfo.IndexOptions indexOptions = op = XContentMapValues.nodeBooleanValue(propNode) ? FieldInfo.IndexOptions.DOCS_ONLY : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
                if (parserContext.indexVersionCreated().onOrAfter(Version.V_1_0_0_RC2)) {
                    throw new ElasticsearchParseException("'omit_term_freq_and_positions' is not supported anymore - use ['index_options' : '" + op.name() + "']  instead");
                }
                builder.indexOptions(op);
                continue;
            }
            if (propName.equals("index_options")) {
                builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                continue;
            }
            if (propName.equals("analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.indexAnalyzer(analyzer);
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("index_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.indexAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name + "]");
                }
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("include_in_all")) {
                builder.includeInAll(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("postings_format")) {
                String postingFormatName = propNode.toString();
                builder.postingsFormat(parserContext.postingFormatService().get(postingFormatName));
                continue;
            }
            if (propName.equals("doc_values_format")) {
                String docValuesFormatName = propNode.toString();
                builder.docValuesFormat(parserContext.docValuesFormatService().get(docValuesFormatName));
                continue;
            }
            if (propName.equals("similarity")) {
                builder.similarity(parserContext.similarityLookupService().similarity(propNode.toString()));
                continue;
            }
            if (propName.equals("fielddata")) {
                Settings settings = ImmutableSettings.builder().put(SettingsLoader.Helper.loadNestedFromMap(XContentMapValues.nodeMapValue(propNode, "fielddata"))).build();
                builder.fieldDataSettings(settings);
                continue;
            }
            if (!propName.equals("copy_to")) continue;
            TypeParsers.parseCopyFields(propNode, builder);
        }
    }

    public static void parseMultiField(AbstractFieldMapper.Builder builder, String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext, String propName, Object propNode) {
        if (propName.equals("path")) {
            builder.multiFieldPathType(TypeParsers.parsePathType(name, propNode.toString()));
        } else if (propName.equals("fields")) {
            Map multiFieldsPropNodes = (Map)propNode;
            for (Map.Entry multiFieldEntry : multiFieldsPropNodes.entrySet()) {
                String multiFieldName = (String)multiFieldEntry.getKey();
                if (!(multiFieldEntry.getValue() instanceof Map)) {
                    throw new MapperParsingException("Illegal field [" + multiFieldName + "], only fields can be specified inside fields");
                }
                Map multiFieldNodes = (Map)multiFieldEntry.getValue();
                Object typeNode = multiFieldNodes.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("No type specified for property [" + multiFieldName + "]");
                }
                String type = typeNode.toString();
                Mapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + multiFieldName + "]");
                }
                builder.addMultiField(typeParser.parse(multiFieldName, multiFieldNodes, parserContext));
            }
        }
    }

    private static FieldInfo.IndexOptions nodeIndexOptionValue(Object propNode) {
        String value = propNode.toString();
        if (INDEX_OPTIONS_OFFSETS.equalsIgnoreCase(value)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value)) {
            return FieldInfo.IndexOptions.DOCS_ONLY;
        }
        throw new ElasticsearchParseException("Failed to parse index option [" + value + "]");
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(String fieldName, Object node) {
        return Joda.forPattern(node.toString());
    }

    public static void parseTermVector(String fieldName, String termVector, AbstractFieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(termVector = Strings.toUnderscoreCase(termVector))) {
            builder.storeTermVectors(false);
        } else if ("yes".equals(termVector)) {
            builder.storeTermVectors(true);
        } else if ("with_offsets".equals(termVector)) {
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions".equals(termVector)) {
            builder.storeTermVectorPositions(true);
        } else if ("with_positions_offsets".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
        } else if ("with_positions_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorPayloads(true);
        } else if ("with_positions_offsets_payloads".equals(termVector)) {
            builder.storeTermVectorPositions(true);
            builder.storeTermVectorOffsets(true);
            builder.storeTermVectorPayloads(true);
        } else {
            throw new MapperParsingException("Wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
        }
    }

    public static void parseIndex(String fieldName, String index, AbstractFieldMapper.Builder builder) throws MapperParsingException {
        if ("no".equals(index = Strings.toUnderscoreCase(index))) {
            builder.index(false);
        } else if ("not_analyzed".equals(index)) {
            builder.index(true);
            builder.tokenized(false);
        } else if ("analyzed".equals(index)) {
            builder.index(true);
            builder.tokenized(true);
        } else {
            throw new MapperParsingException("Wrong value for index [" + index + "] for field [" + fieldName + "]");
        }
    }

    public static boolean parseDocValues(String docValues) {
        if ("no".equals(docValues)) {
            return false;
        }
        if ("yes".equals(docValues)) {
            return true;
        }
        return XContentMapValues.nodeBooleanValue(docValues);
    }

    public static boolean parseStore(String fieldName, String store) throws MapperParsingException {
        if ("no".equals(store)) {
            return false;
        }
        if ("yes".equals(store)) {
            return true;
        }
        return XContentMapValues.nodeBooleanValue(store);
    }

    public static ContentPath.Type parsePathType(String name, String path) throws MapperParsingException {
        if ("just_name".equals(path = Strings.toUnderscoreCase(path))) {
            return ContentPath.Type.JUST_NAME;
        }
        if ("full".equals(path)) {
            return ContentPath.Type.FULL;
        }
        throw new MapperParsingException("Wrong value for pathType [" + path + "] for object [" + name + "]");
    }

    public static void parseCopyFields(Object propNode, AbstractFieldMapper.Builder builder) {
        AbstractFieldMapper.CopyTo.Builder copyToBuilder = new AbstractFieldMapper.CopyTo.Builder();
        if (XContentMapValues.isArray(propNode)) {
            for (Object node : (List)propNode) {
                copyToBuilder.add(XContentMapValues.nodeStringValue(node, null));
            }
        } else {
            copyToBuilder.add(XContentMapValues.nodeStringValue(propNode, null));
        }
        builder.copyTo(copyToBuilder.build());
    }
}

