/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.geo.InMemoryGeoBoundingBoxFilter;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxFilter;

public class GeoBoundingBoxFilterParser
implements FilterParser {
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String BOTTOM = "bottom";
    public static final String TOP_LEFT = "top_left";
    public static final String TOP_RIGHT = "top_right";
    public static final String BOTTOM_LEFT = "bottom_left";
    public static final String BOTTOM_RIGHT = "bottom_right";
    public static final String TOPLEFT = "topLeft";
    public static final String TOPRIGHT = "topRight";
    public static final String BOTTOMLEFT = "bottomLeft";
    public static final String BOTTOMRIGHT = "bottomRight";
    public static final String NAME = "geo_bbox";
    public static final String FIELD = "field";

    @Inject
    public GeoBoundingBoxFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "geoBbox", "geo_bounding_box", "geoBoundingBox"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter filter;
        MapperService.SmartNameFieldMappers smartMappers;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String fieldName = null;
        double top = Double.NaN;
        double bottom = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        String filterName = null;
        String currentFieldName = null;
        boolean normalize = true;
        GeoPoint sparse = new GeoPoint();
        String type = "memory";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (FIELD.equals(currentFieldName)) {
                            fieldName = parser.text();
                            continue;
                        }
                        if (TOP.equals(currentFieldName)) {
                            top = parser.doubleValue();
                            continue;
                        }
                        if (BOTTOM.equals(currentFieldName)) {
                            bottom = parser.doubleValue();
                            continue;
                        }
                        if (LEFT.equals(currentFieldName)) {
                            left = parser.doubleValue();
                            continue;
                        }
                        if (RIGHT.equals(currentFieldName)) {
                            right = parser.doubleValue();
                            continue;
                        }
                        if (TOP_LEFT.equals(currentFieldName) || TOPLEFT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            top = sparse.getLat();
                            left = sparse.getLon();
                            continue;
                        }
                        if (BOTTOM_RIGHT.equals(currentFieldName) || BOTTOMRIGHT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            bottom = sparse.getLat();
                            right = sparse.getLon();
                            continue;
                        }
                        if (TOP_RIGHT.equals(currentFieldName) || TOPRIGHT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            top = sparse.getLat();
                            right = sparse.getLon();
                            continue;
                        }
                        if (BOTTOM_LEFT.equals(currentFieldName) || BOTTOMLEFT.equals(currentFieldName)) {
                            GeoUtils.parseGeoPoint(parser, sparse);
                            bottom = sparse.getLat();
                            left = sparse.getLon();
                            continue;
                        }
                        throw new ElasticsearchParseException("Unexpected field [" + currentFieldName + "]");
                    }
                    throw new ElasticsearchParseException("fieldname expected but [" + (Object)((Object)token) + "] found");
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            if ("normalize".equals(currentFieldName)) {
                normalize = parser.booleanValue();
                continue;
            }
            if ("type".equals(currentFieldName)) {
                type = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[geo_bbox] filter does not support [" + currentFieldName + "]");
        }
        GeoPoint topLeft = sparse.reset(top, left);
        GeoPoint bottomRight = new GeoPoint(bottom, right);
        if (normalize) {
            GeoUtils.normalizePoint(topLeft);
            GeoUtils.normalizePoint(bottomRight);
        }
        if ((smartMappers = parseContext.smartFieldMappers(fieldName)) == null || !smartMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "failed to find geo_point field [" + fieldName + "]");
        }
        FieldMapper mapper = smartMappers.mapper();
        if (!(mapper instanceof GeoPointFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "field [" + fieldName + "] is not a geo_point field");
        }
        GeoPointFieldMapper geoMapper = (GeoPointFieldMapper)mapper;
        if ("indexed".equals(type)) {
            filter = IndexedGeoBoundingBoxFilter.create(topLeft, bottomRight, geoMapper);
        } else if ("memory".equals(type)) {
            IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.getForField(mapper);
            filter = new InMemoryGeoBoundingBoxFilter(topLeft, bottomRight, indexFieldData);
        } else {
            throw new QueryParsingException(parseContext.index(), "geo bounding box type [" + type + "] not supported, either 'indexed' or 'memory' are allowed");
        }
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

