/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.index.fielddata.fieldcomparator.NestedWrappableComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;

abstract class NestedFieldComparator
extends FieldComparator {
    final Filter rootDocumentsFilter;
    final Filter innerDocumentsFilter;
    final int spareSlot;
    FieldComparator wrappedComparator;
    FixedBitSet rootDocuments;
    FixedBitSet innerDocuments;
    int bottomSlot;
    Object top;

    NestedFieldComparator(FieldComparator wrappedComparator, Filter rootDocumentsFilter, Filter innerDocumentsFilter, int spareSlot) {
        this.wrappedComparator = wrappedComparator;
        this.rootDocumentsFilter = rootDocumentsFilter;
        this.innerDocumentsFilter = innerDocumentsFilter;
        this.spareSlot = spareSlot;
    }

    public final int compare(int slot1, int slot2) {
        return this.wrappedComparator.compare(slot1, slot2);
    }

    public final void setBottom(int slot) {
        this.wrappedComparator.setBottom(slot);
        this.bottomSlot = slot;
    }

    public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
        DocIdSet innerDocuments = this.innerDocumentsFilter.getDocIdSet(context, null);
        this.innerDocuments = DocIdSets.isEmpty(innerDocuments) ? null : (innerDocuments instanceof FixedBitSet ? (FixedBitSet)innerDocuments : DocIdSets.toFixedBitSet(innerDocuments.iterator(), context.reader().maxDoc()));
        DocIdSet rootDocuments = this.rootDocumentsFilter.getDocIdSet(context, null);
        this.rootDocuments = DocIdSets.isEmpty(rootDocuments) ? null : (rootDocuments instanceof FixedBitSet ? (FixedBitSet)rootDocuments : DocIdSets.toFixedBitSet(rootDocuments.iterator(), context.reader().maxDoc()));
        this.wrappedComparator = this.wrappedComparator.setNextReader(context);
        return this;
    }

    public final Object value(int slot) {
        return this.wrappedComparator.value(slot);
    }

    public void setTopValue(Object top) {
        this.top = top;
        this.wrappedComparator.setTopValue(top);
    }

    static final void copyMissing(FieldComparator<?> comparator, int slot) {
        if (comparator instanceof NestedWrappableComparator) {
            ((NestedWrappableComparator)comparator).missing(slot);
        }
    }

    static final int compareBottomMissing(FieldComparator<?> comparator) {
        if (comparator instanceof NestedWrappableComparator) {
            return ((NestedWrappableComparator)comparator).compareBottomMissing();
        }
        return 0;
    }

    static final int compareTopMissing(FieldComparator<?> comparator) {
        if (comparator instanceof NestedWrappableComparator) {
            return ((NestedWrappableComparator)comparator).compareTopMissing();
        }
        return 0;
    }

    static final class Avg
    extends NumericNestedFieldComparatorBase {
        Avg(NumberComparatorBase wrappedComparator, Filter rootDocumentsFilter, Filter innerDocumentsFilter, int spareSlot) {
            super(wrappedComparator, rootDocumentsFilter, innerDocumentsFilter, spareSlot);
        }

        @Override
        protected void onNested(int slot, int nestedDoc) {
            this.numberComparator.add(slot, nestedDoc);
        }

        @Override
        protected void afterNested(int slot, int count) {
            this.numberComparator.divide(slot, count);
        }
    }

    static final class Sum
    extends NumericNestedFieldComparatorBase {
        Sum(NumberComparatorBase wrappedComparator, Filter rootDocumentsFilter, Filter innerDocumentsFilter, int spareSlot) {
            super(wrappedComparator, rootDocumentsFilter, innerDocumentsFilter, spareSlot);
        }

        @Override
        protected void onNested(int slot, int nestedDoc) {
            this.numberComparator.add(slot, nestedDoc);
        }

        @Override
        protected void afterNested(int slot, int count) {
        }
    }

    static abstract class NumericNestedFieldComparatorBase
    extends NestedFieldComparator {
        protected NumberComparatorBase numberComparator;

        NumericNestedFieldComparatorBase(NumberComparatorBase wrappedComparator, Filter rootDocumentsFilter, Filter innerDocumentsFilter, int spareSlot) {
            super(wrappedComparator, rootDocumentsFilter, innerDocumentsFilter, spareSlot);
            this.numberComparator = wrappedComparator;
        }

        public final int compareBottom(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return NumericNestedFieldComparatorBase.compareBottomMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return NumericNestedFieldComparatorBase.compareBottomMissing(this.wrappedComparator);
            }
            int counter = 1;
            this.wrappedComparator.copy(this.spareSlot, nestedDoc);
            nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            while (nestedDoc > prevRootDoc && nestedDoc < rootDoc) {
                this.onNested(this.spareSlot, nestedDoc);
                nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
                ++counter;
            }
            this.afterNested(this.spareSlot, counter);
            return this.compare(this.bottomSlot, this.spareSlot);
        }

        public final void copy(int slot, int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                NumericNestedFieldComparatorBase.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                NumericNestedFieldComparatorBase.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int counter = 1;
            this.wrappedComparator.copy(slot, nestedDoc);
            nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            while (nestedDoc > prevRootDoc && nestedDoc < rootDoc) {
                this.onNested(slot, nestedDoc);
                nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
                ++counter;
            }
            this.afterNested(slot, counter);
        }

        public int compareTop(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return NumericNestedFieldComparatorBase.compareTopMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return NumericNestedFieldComparatorBase.compareTopMissing(this.wrappedComparator);
            }
            int counter = 1;
            this.wrappedComparator.copy(this.spareSlot, nestedDoc);
            nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
            while (nestedDoc > prevRootDoc && nestedDoc < rootDoc) {
                this.onNested(this.spareSlot, nestedDoc);
                nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1);
                ++counter;
            }
            this.afterNested(this.spareSlot, counter);
            return this.wrappedComparator.compareValues(this.wrappedComparator.value(this.spareSlot), this.top);
        }

        protected abstract void onNested(int var1, int var2);

        protected abstract void afterNested(int var1, int var2);

        @Override
        public final FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            this.numberComparator = (NumberComparatorBase)this.wrappedComparator;
            return this;
        }
    }

    static final class Highest
    extends NestedFieldComparator {
        Highest(FieldComparator wrappedComparator, Filter parentFilter, Filter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        public int compareBottom(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return Highest.compareBottomMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Highest.compareBottomMissing(this.wrappedComparator);
            }
            int cmp = this.wrappedComparator.compareBottom(nestedDoc);
            if (cmp < 0) {
                return cmp;
            }
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                int cmp1 = this.wrappedComparator.compareBottom(nestedDoc);
                if (cmp1 < 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        public void copy(int slot, int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                Highest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                Highest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            this.wrappedComparator.copy(slot, nestedDoc);
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                this.wrappedComparator.copy(this.spareSlot, nestedDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) <= 0) continue;
                this.wrappedComparator.copy(slot, nestedDoc);
            }
            return;
        }

        public int compareTop(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return Highest.compareTopMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Highest.compareTopMissing(this.wrappedComparator);
            }
            int cmp = this.wrappedComparator.compareTop(nestedDoc);
            if (cmp < 0) {
                return cmp;
            }
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                int cmp1 = this.wrappedComparator.compareTop(nestedDoc);
                if (cmp1 < 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }
    }

    static final class Lowest
    extends NestedFieldComparator {
        Lowest(FieldComparator wrappedComparator, Filter parentFilter, Filter childFilter, int spareSlot) {
            super(wrappedComparator, parentFilter, childFilter, spareSlot);
        }

        public int compareBottom(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return Lowest.compareBottomMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Lowest.compareBottomMissing(this.wrappedComparator);
            }
            int cmp = this.wrappedComparator.compareBottom(nestedDoc);
            if (cmp > 0) {
                return cmp;
            }
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                int cmp1 = this.wrappedComparator.compareBottom(nestedDoc);
                if (cmp1 > 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }

        public void copy(int slot, int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                Lowest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                Lowest.copyMissing(this.wrappedComparator, slot);
                return;
            }
            this.wrappedComparator.copy(slot, nestedDoc);
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                this.wrappedComparator.copy(this.spareSlot, nestedDoc);
                if (this.wrappedComparator.compare(this.spareSlot, slot) >= 0) continue;
                this.wrappedComparator.copy(slot, nestedDoc);
            }
            return;
        }

        public int compareTop(int rootDoc) throws IOException {
            if (rootDoc == 0 || this.rootDocuments == null || this.innerDocuments == null) {
                return Lowest.compareTopMissing(this.wrappedComparator);
            }
            int prevRootDoc = this.rootDocuments.prevSetBit(rootDoc - 1);
            int nestedDoc = this.innerDocuments.nextSetBit(prevRootDoc + 1);
            if (nestedDoc >= rootDoc || nestedDoc == -1) {
                return Lowest.compareTopMissing(this.wrappedComparator);
            }
            int cmp = this.wrappedComparator.compareTop(nestedDoc);
            if (cmp > 0) {
                return cmp;
            }
            while ((nestedDoc = this.innerDocuments.nextSetBit(nestedDoc + 1)) < rootDoc && nestedDoc != -1) {
                int cmp1 = this.wrappedComparator.compareTop(nestedDoc);
                if (cmp1 > 0) {
                    return cmp1;
                }
                if (cmp1 != 0) continue;
                cmp = 0;
            }
            return cmp;
        }
    }
}

