/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.cache.clear;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestClearIndicesCacheAction
extends BaseRestHandler {
    @Inject
    public RestClearIndicesCacheAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_cache/clear", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        ClearIndicesCacheRequest clearIndicesCacheRequest = new ClearIndicesCacheRequest(Strings.splitStringByCommaToArray(request.param("index")));
        clearIndicesCacheRequest.listenerThreaded(false);
        clearIndicesCacheRequest.indicesOptions(IndicesOptions.fromRequest(request, clearIndicesCacheRequest.indicesOptions()));
        RestClearIndicesCacheAction.fromRequest(request, clearIndicesCacheRequest);
        client.admin().indices().clearCache(clearIndicesCacheRequest, (ActionListener<ClearIndicesCacheResponse>)new RestBuilderListener<ClearIndicesCacheResponse>(channel){

            @Override
            public RestResponse buildResponse(ClearIndicesCacheResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, response);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    public static ClearIndicesCacheRequest fromRequest(RestRequest request, ClearIndicesCacheRequest clearIndicesCacheRequest) {
        for (Map.Entry<String, String> entry : request.params().entrySet()) {
            if (Fields.FILTER.match(entry.getKey())) {
                clearIndicesCacheRequest.filterCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.filterCache()));
            }
            if (Fields.FIELD_DATA.match(entry.getKey())) {
                clearIndicesCacheRequest.fieldDataCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.fieldDataCache()));
            }
            if (Fields.ID.match(entry.getKey())) {
                clearIndicesCacheRequest.idCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.idCache()));
            }
            if (Fields.RECYCLER.match(entry.getKey())) {
                clearIndicesCacheRequest.recycler(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.recycler()));
            }
            if (Fields.FIELDS.match(entry.getKey())) {
                clearIndicesCacheRequest.fields(request.paramAsStringArray(entry.getKey(), clearIndicesCacheRequest.fields()));
            }
            if (!Fields.FILTER_KEYS.match(entry.getKey())) continue;
            clearIndicesCacheRequest.filterKeys(request.paramAsStringArray(entry.getKey(), clearIndicesCacheRequest.filterKeys()));
        }
        return clearIndicesCacheRequest;
    }

    public static class Fields {
        public static final ParseField FILTER = new ParseField("filter", "filter_cache");
        public static final ParseField FIELD_DATA = new ParseField("field_data", "fielddata");
        public static final ParseField ID = new ParseField("id", "id_cache");
        public static final ParseField RECYCLER = new ParseField("recycler", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField FILTER_KEYS = new ParseField("filter_keys", new String[0]);
    }
}

