/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.stats;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestIndicesStatsAction
extends BaseRestHandler {
    @Inject
    public RestIndicesStatsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/_stats/{metric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_stats/{metric}/{indexMetric}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_stats/{metric}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        IndicesStatsRequest indicesStatsRequest = new IndicesStatsRequest();
        indicesStatsRequest.listenerThreaded(false);
        indicesStatsRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesStatsRequest.indicesOptions()));
        indicesStatsRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
        Set<String> metrics = Strings.splitStringByCommaToSet(request.param("metric", "_all"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            indicesStatsRequest.all();
        } else {
            indicesStatsRequest.clear();
            indicesStatsRequest.docs(metrics.contains("docs"));
            indicesStatsRequest.store(metrics.contains("store"));
            indicesStatsRequest.indexing(metrics.contains("indexing"));
            indicesStatsRequest.search(metrics.contains("search"));
            indicesStatsRequest.get(metrics.contains("get"));
            indicesStatsRequest.merge(metrics.contains("merge"));
            indicesStatsRequest.refresh(metrics.contains("refresh"));
            indicesStatsRequest.flush(metrics.contains("flush"));
            indicesStatsRequest.warmer(metrics.contains("warmer"));
            indicesStatsRequest.filterCache(metrics.contains("filter_cache"));
            indicesStatsRequest.idCache(metrics.contains("id_cache"));
            indicesStatsRequest.percolate(metrics.contains("percolate"));
            indicesStatsRequest.segments(metrics.contains("segments"));
            indicesStatsRequest.fieldData(metrics.contains("fielddata"));
            indicesStatsRequest.completion(metrics.contains("completion"));
            indicesStatsRequest.suggest(metrics.contains("suggest"));
        }
        if (request.hasParam("groups")) {
            indicesStatsRequest.groups(Strings.splitStringByCommaToArray(request.param("groups")));
        }
        if (request.hasParam("types")) {
            indicesStatsRequest.types(Strings.splitStringByCommaToArray(request.param("types")));
        }
        if (indicesStatsRequest.completion() && (request.hasParam("fields") || request.hasParam("completion_fields"))) {
            indicesStatsRequest.completionFields(request.paramAsStringArray("completion_fields", request.paramAsStringArray("fields", Strings.EMPTY_ARRAY)));
        }
        if (indicesStatsRequest.fieldData() && (request.hasParam("fields") || request.hasParam("fielddata_fields"))) {
            indicesStatsRequest.fieldDataFields(request.paramAsStringArray("fielddata_fields", request.paramAsStringArray("fields", Strings.EMPTY_ARRAY)));
        }
        client.admin().indices().stats(indicesStatsRequest, (ActionListener<IndicesStatsResponse>)new RestBuilderListener<IndicesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesStatsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, response);
                response.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

