/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.template;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.script.ScriptService;

public class RestDeleteSearchTemplateAction
extends BaseRestHandler {
    private ScriptService scriptService;

    @Inject
    public RestDeleteSearchTemplateAction(Settings settings, Client client, RestController controller, ScriptService scriptService) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.DELETE, "/_search/template/{id}", this);
        this.scriptService = scriptService;
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        String id = request.param("id");
        long version = request.paramAsLong("version", -3L);
        this.scriptService.deleteScriptFromIndex(client, "mustache", id, version, (ActionListener<DeleteResponse>)new RestBuilderListener<DeleteResponse>(channel){

            @Override
            public RestResponse buildResponse(DeleteResponse result, XContentBuilder builder) throws Exception {
                builder.startObject().field(Fields.FOUND, result.isFound()).field(Fields._INDEX, result.getIndex()).field(Fields._TYPE, result.getType()).field(Fields._ID, result.getId()).field(Fields._VERSION, result.getVersion()).endObject();
                RestStatus status = RestStatus.OK;
                if (!result.isFound()) {
                    status = RestStatus.NOT_FOUND;
                }
                return new BytesRestResponse(status, builder);
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString FOUND = new XContentBuilderString("found");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");

        Fields() {
        }
    }
}

