/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.template;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.get.GetIndexedScriptResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestResponseListener;
import org.elasticsearch.script.ScriptService;

public class RestGetSearchTemplateAction
extends BaseRestHandler {
    @Inject
    public RestGetSearchTemplateAction(Settings settings, Client client, RestController controller, ScriptService scriptService) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_search/template/{id}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        GetIndexedScriptRequest getRequest = new GetIndexedScriptRequest(".scripts", "mustache", request.param("id"));
        RestResponseListener<GetIndexedScriptResponse> responseListener = new RestResponseListener<GetIndexedScriptResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexedScriptResponse response) throws Exception {
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
                if (!response.isExists()) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                try {
                    String templateString = response.getScript();
                    builder.startObject();
                    builder.field("template", templateString);
                    builder.endObject();
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
                catch (IOException | ClassCastException e) {
                    throw new ElasticsearchIllegalStateException("Unable to parse " + response.getScript() + " as json", e);
                }
            }
        };
        client.getIndexedScript(getRequest, (ActionListener<GetIndexedScriptResponse>)responseListener);
    }
}

