/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicBuilder;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;

public class MutualInformation
implements SignificanceHeuristic {
    protected static final ParseField NAMES_FIELD = new ParseField("mutual_information", new String[0]);
    protected static final ParseField INCLUDE_NEGATIVES_FIELD = new ParseField("include_negatives", new String[0]);
    protected static final ParseField BACKGROUND_IS_SUPERSET = new ParseField("background_is_superset", new String[0]);
    protected static final String SCORE_ERROR_MESSAGE = ", does your background filter not include all documents in the bucket? If so and it is intentional, set \"" + BACKGROUND_IS_SUPERSET.getPreferredName() + "\": false";
    private static final double log2 = Math.log(2.0);
    protected boolean includeNegatives = false;
    private boolean backgroundIsSuperset = true;
    public static final SignificanceHeuristicStreams.Stream STREAM = new SignificanceHeuristicStreams.Stream(){

        @Override
        public SignificanceHeuristic readResult(StreamInput in) throws IOException {
            return new MutualInformation(in.readBoolean(), in.readBoolean());
        }

        @Override
        public String getName() {
            return NAMES_FIELD.getPreferredName();
        }
    };

    private MutualInformation() {
    }

    public MutualInformation(boolean includeNegatives, boolean backgroundIsSuperset) {
        this.includeNegatives = includeNegatives;
        this.backgroundIsSuperset = backgroundIsSuperset;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MutualInformation)) {
            return false;
        }
        return ((MutualInformation)other).includeNegatives == this.includeNegatives && ((MutualInformation)other).backgroundIsSuperset == this.backgroundIsSuperset;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        double N;
        double N_1;
        double N_0;
        double N1_;
        double N0_;
        double N11;
        double N10;
        double N01;
        double N00;
        if (subsetFreq < 0L || subsetSize < 0L || supersetFreq < 0L || supersetSize < 0L) {
            throw new ElasticsearchIllegalArgumentException("Frequencies of subset and superset must be positive in MutualInformation.getScore()");
        }
        if (subsetFreq > subsetSize) {
            throw new ElasticsearchIllegalArgumentException("subsetFreq > subsetSize, in MutualInformation.score(..)");
        }
        if (supersetFreq > supersetSize) {
            throw new ElasticsearchIllegalArgumentException("supersetFreq > supersetSize, in MutualInformation.score(..)");
        }
        if (this.backgroundIsSuperset) {
            if (subsetFreq > supersetFreq) {
                throw new ElasticsearchIllegalArgumentException("subsetFreq > supersetFreq" + SCORE_ERROR_MESSAGE);
            }
            if (subsetSize > supersetSize) {
                throw new ElasticsearchIllegalArgumentException("subsetSize > supersetSize" + SCORE_ERROR_MESSAGE);
            }
            if (supersetFreq - subsetFreq > supersetSize - subsetSize) {
                throw new ElasticsearchIllegalArgumentException("supersetFreq - subsetFreq > supersetSize - subsetSize" + SCORE_ERROR_MESSAGE);
            }
        }
        if (this.backgroundIsSuperset) {
            N00 = supersetSize - supersetFreq - (subsetSize - subsetFreq);
            N01 = subsetSize - subsetFreq;
            N10 = supersetFreq - subsetFreq;
            N11 = subsetFreq;
            N0_ = supersetSize - supersetFreq;
            N1_ = supersetFreq;
            N_0 = supersetSize - subsetSize;
            N_1 = subsetSize;
            N = supersetSize;
        } else {
            N00 = supersetSize - supersetFreq;
            N01 = subsetSize - subsetFreq;
            N10 = supersetFreq;
            N11 = subsetFreq;
            N0_ = supersetSize - supersetFreq + subsetSize - subsetFreq;
            N1_ = supersetFreq + subsetFreq;
            N_0 = supersetSize;
            N_1 = subsetSize;
            N = supersetSize + subsetSize;
        }
        double score = (this.getMITerm(N00, N0_, N_0, N) + this.getMITerm(N01, N0_, N_1, N) + this.getMITerm(N10, N1_, N_0, N) + this.getMITerm(N11, N1_, N_1, N)) / log2;
        if (Double.isNaN(score)) {
            score = -3.4028234663852886E38;
        }
        if (!this.includeNegatives && N11 / N_1 < N10 / N_0) {
            score = -1.7976931348623157E308;
        }
        return score;
    }

    double getMITerm(double Nxy, double Nx_, double N_y, double N) {
        double numerator = Math.abs(N * Nxy);
        double denominator = Math.abs(Nx_ * N_y);
        double factor = Math.abs(Nxy / N);
        if (numerator < 1.0E-7 && factor < 1.0E-7) {
            return 0.0;
        }
        return factor * Math.log(numerator / denominator);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
        out.writeBoolean(this.includeNegatives);
        out.writeBoolean(this.backgroundIsSuperset);
    }

    public boolean getIncludeNegatives() {
        return this.includeNegatives;
    }

    public int hashCode() {
        int result = this.includeNegatives ? 1 : 0;
        result = 31 * result + (this.backgroundIsSuperset ? 1 : 0);
        return result;
    }

    public static class MutualInformationBuilder
    implements SignificanceHeuristicBuilder {
        boolean includeNegatives = true;
        private boolean backgroundIsSuperset = true;

        private MutualInformationBuilder() {
        }

        public MutualInformationBuilder(boolean includeNegatives, boolean backgroundIsSuperset) {
            this.includeNegatives = includeNegatives;
            this.backgroundIsSuperset = backgroundIsSuperset;
        }

        @Override
        public void toXContent(XContentBuilder builder) throws IOException {
            builder.startObject(STREAM.getName()).field(INCLUDE_NEGATIVES_FIELD.getPreferredName(), this.includeNegatives).field(BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset).endObject();
        }
    }

    public static class MutualInformationParser
    implements SignificanceHeuristicParser {
        @Override
        public SignificanceHeuristic parse(XContentParser parser) throws IOException, QueryParsingException {
            NAMES_FIELD.match(parser.currentName(), ParseField.EMPTY_FLAGS);
            boolean includeNegatives = false;
            boolean backgroundIsSuperset = true;
            XContentParser.Token token = parser.nextToken();
            while (!token.equals((Object)XContentParser.Token.END_OBJECT)) {
                if (INCLUDE_NEGATIVES_FIELD.match(parser.currentName(), ParseField.EMPTY_FLAGS)) {
                    parser.nextToken();
                    includeNegatives = parser.booleanValue();
                } else if (BACKGROUND_IS_SUPERSET.match(parser.currentName(), ParseField.EMPTY_FLAGS)) {
                    parser.nextToken();
                    backgroundIsSuperset = parser.booleanValue();
                } else {
                    throw new ElasticsearchParseException("Field " + parser.currentName().toString() + " unknown for mutual_information.");
                }
                token = parser.nextToken();
            }
            return new MutualInformation(includeNegatives, backgroundIsSuperset);
        }

        @Override
        public String[] getNames() {
            return NAMES_FIELD.getAllNamesIncludedDeprecated();
        }
    }
}

