/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.context;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.search.suggest.context.CategoryContextMapping;
import org.elasticsearch.search.suggest.context.ContextMapping;
import org.elasticsearch.search.suggest.context.GeolocationContextMapping;

public abstract class ContextBuilder<E extends ContextMapping> {
    protected String name;

    public ContextBuilder(String name) {
        this.name = name;
    }

    public abstract E build();

    public static GeolocationContextMapping.Builder location(String name) {
        return new GeolocationContextMapping.Builder(name);
    }

    public static GeolocationContextMapping.Builder location(String name, int precision, boolean neighbors) {
        return new GeolocationContextMapping.Builder(name, neighbors, precision);
    }

    public static CategoryContextMapping.Builder category(String name) {
        return new CategoryContextMapping.Builder(name, null);
    }

    public static CategoryContextMapping.Builder category(String name, String defaultCategory) {
        return new CategoryContextMapping.Builder(name, null).addDefaultValue(defaultCategory);
    }

    public static CategoryContextMapping.Builder reference(String name, String fieldname) {
        return new CategoryContextMapping.Builder(name, fieldname);
    }

    public static CategoryContextMapping.Builder reference(String name, String fieldname, Iterable<? extends CharSequence> defaultValues) {
        return new CategoryContextMapping.Builder(name, fieldname).addDefaultValues(defaultValues);
    }

    public static SortedMap<String, ContextMapping> loadMappings(Object configuration) throws ElasticsearchParseException {
        if (configuration instanceof Map) {
            Map configurations = (Map)configuration;
            TreeMap<String, ContextMapping> mappings = Maps.newTreeMap();
            for (Map.Entry config : configurations.entrySet()) {
                String name = (String)config.getKey();
                mappings.put(name, ContextBuilder.loadMapping(name, (Map)config.getValue()));
            }
            return mappings;
        }
        if (configuration == null) {
            return ContextMapping.EMPTY_MAPPING;
        }
        throw new ElasticsearchParseException("no valid context configuration");
    }

    protected static ContextMapping loadMapping(String name, Map<String, Object> config) throws ElasticsearchParseException {
        Object argType = config.get("type");
        if (argType == null) {
            throw new ElasticsearchParseException("missing [type] in context mapping");
        }
        String type = argType.toString();
        if ("geo".equals(type)) {
            return GeolocationContextMapping.load(name, config);
        }
        if ("category".equals(type)) {
            return CategoryContextMapping.load(name, config);
        }
        throw new ElasticsearchParseException("unknown context type[" + type + "]");
    }
}

