/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.net.UrlEscapers;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.xltest.jenkins.JenkinsFile;
import com.xebialabs.xltest.jenkins.JenkinsQueueInspector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.resteasy.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Protocol(name="jenkins")
public class JenkinsConnection
extends BaseOverthereConnection
implements OverthereConnectionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JenkinsConnection.class);
    public static final String JENKINS_PROTOCOL = "jenkins";
    public static final String JOB_NAME = "jobName";
    public static final String UNIQUE_ID_PARAMETER = "XL_TEST_RUN_ID";
    public static final String JOB_PARAMETERS = "jobParameters";
    public static final String TIMEOUT = "timeout";
    private final URL address;
    private final String username;
    private final String password;
    private final String jobName;
    private final Map<String, String> jobParameters;
    private File localWorkspaceDirectory;

    public JenkinsConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, options, mapper, true);
        String addr = (String)options.get("address");
        try {
            this.address = new URL(addr);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeIOException((Throwable)mue);
        }
        this.username = (String)options.getOptional("username");
        this.password = (String)options.getOptional("password");
        this.jobName = (String)options.get(JOB_NAME);
        this.jobParameters = (Map)options.getOptional(JOB_PARAMETERS);
    }

    public OverthereFile getFile(String hostPath) {
        LOG.info("Looking for path: {}", (Object)hostPath);
        return new JenkinsFile(this, hostPath);
    }

    public OverthereFile getFile(OverthereFile parent, String child) {
        LOG.info("Looking for path: {}/{}", (Object)parent, (Object)child);
        return new JenkinsFile(this, (JenkinsFile)parent, child);
    }

    public void execute(Map<String, Object> parameters) {
        OverthereProcess process = this.startProcess(parameters);
        try {
            process.waitFor();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            LOG.info("Execution interrupted, destroying the process.");
            process.destroy();
            throw new RuntimeIOException("Execution interrupted", (Throwable)exc);
        }
    }

    public OverthereProcess startProcess(CmdLine commandLine) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.jobParameters != null) {
            parameters.putAll(this.jobParameters);
        }
        parameters.put("commandLine", commandLine.toCommandLine(this.getHostOperatingSystem(), false));
        return this.startProcess(parameters);
    }

    public OverthereProcess startProcess(Map<String, Object> jobParameters) {
        String uniqueId = jobParameters.containsKey(UNIQUE_ID_PARAMETER) ? jobParameters.get(UNIQUE_ID_PARAMETER).toString() : UUID.randomUUID().toString();
        int timeout = jobParameters.containsKey(TIMEOUT) ? Integer.parseInt(jobParameters.get(TIMEOUT).toString()) : 0;
        HashMap<String, Object> parameters = new HashMap<String, Object>(jobParameters);
        parameters.put(UNIQUE_ID_PARAMETER, uniqueId);
        JenkinsQueueInspector jenkinsQueueInspector = new JenkinsQueueInspector(this.address, this.jobName, this.username, this.password, UNIQUE_ID_PARAMETER, uniqueId);
        int responseCode = this.buildJob(parameters);
        if (responseCode >= 400) {
            return null;
        }
        return new JenkinsOverthereProcess(jenkinsQueueInspector, timeout);
    }

    public OverthereConnection connect() {
        return this;
    }

    protected void doClose() {
    }

    public OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        throw new UnsupportedOperationException("Cannot deal with temp files on " + (Object)((Object)this));
    }

    public String toString() {
        return "jenkins:" + this.username + "@" + this.address + "job/" + this.jobName;
    }

    protected File downloadJenkinsWorkspace(String hostPath) {
        if (this.localWorkspaceDirectory != null) {
            return this.localWorkspaceDirectory;
        }
        HttpURLConnection conn = null;
        try {
            File saveDir = this.newLocalWorkspaceDirectory(hostPath);
            String fileName = "xltest-download.zip";
            URL zipUrl = new URL(this.address, String.format("job/%s/ws/%s/*zip*/%s", this.escape(this.jobName), this.escape(hostPath), this.escape("xltest-download.zip")));
            conn = (HttpURLConnection)zipUrl.openConnection();
            this.addHeaders(conn);
            int responseCode = conn.getResponseCode();
            switch (responseCode) {
                case 200: {
                    try (InputStream inputStream = conn.getInputStream();){
                        this.extract(saveDir, inputStream);
                    }
                    LOG.debug("Done, unzipped in dir: " + this.localWorkspaceDirectory.getPath());
                    break;
                }
                case 401: {
                    if (this.username != null) {
                        throw new RuntimeIOException(String.format("Can not log on to Jenkins with user %s", this.username));
                    }
                    throw new RuntimeIOException(String.format("Authorization is required for Jenkins at %s", this.address));
                }
                case 403: {
                    throw new RuntimeIOException(String.format("Not allowed to access workspace folder '%s'", hostPath));
                }
                case 404: {
                    throw new RuntimeIOException(String.format("The folder '%s' could not be found in the workspace for job %s", hostPath, this.jobName));
                }
                default: {
                    throw new RuntimeIOException(String.format("Unable to download workspace folder '%s'(status code = %d)", hostPath, responseCode));
                }
            }
            File file = this.localWorkspaceDirectory;
            return file;
        }
        catch (IOException e) {
            this.localWorkspaceDirectory = null;
            throw new RuntimeIOException(String.format("Can not connect to Jenkins on URL %s (invalid url?)", this.address), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String escape(String s) throws UnsupportedEncodingException {
        return UrlEscapers.urlFragmentEscaper().escape(s);
    }

    private File newLocalWorkspaceDirectory(String hostPath) {
        File saveDir;
        this.localWorkspaceDirectory = Files.createTempDir();
        String parent = new File(hostPath).getParent();
        if (parent != null) {
            saveDir = new File(this.localWorkspaceDirectory, parent);
        } else {
            saveDir = this.localWorkspaceDirectory;
            if ("".equals(hostPath) || "/".equals(hostPath) || ".".equals(hostPath)) {
                this.localWorkspaceDirectory = new File(this.localWorkspaceDirectory, "workspace");
            }
        }
        return saveDir;
    }

    private HttpURLConnection addHeaders(HttpURLConnection conn) {
        conn.setInstanceFollowRedirects(true);
        if (!Strings.isNullOrEmpty((String)this.username)) {
            String userPassword = this.username + ":" + (this.password != null ? this.password : "");
            String encoding = new String(Base64.encodeBytes((byte[])userPassword.getBytes()));
            conn.setRequestProperty("Authorization", "Basic " + encoding);
        }
        return conn;
    }

    protected void extract(File baseDir, InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File file = new File(baseDir, entry.getName());
            LOG.debug("Copying {} into file {}", (Object)entry.getName(), (Object)file);
            Files.createParentDirs((File)file);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zis), (File)file);
        }
    }

    public int buildJob(Map<String, Object> parameters) {
        HttpURLConnection conn = null;
        try {
            URL buildURL = new URL(this.address, String.format("job/%s/buildWithParameters", this.escape(this.jobName)));
            byte[] data = this.makeContent(parameters).getBytes("UTF-8");
            LOG.info("Kicking off a job on Jenkins using this URL: " + buildURL.toString());
            conn = (HttpURLConnection)buildURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setUseCaches(false);
            this.addHeaders(conn);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            conn.setRequestProperty("Content-Length", Integer.toString(data.length));
            try (OutputStream out = conn.getOutputStream();){
                out.write(data);
                out.flush();
            }
            int responseCode = conn.getResponseCode();
            LOG.info("Kicking off a job on Jenkins resulted in http responseCode: " + responseCode);
            int n = responseCode;
            return n;
        }
        catch (MalformedURLException e) {
            throw new RuntimeIOException("Invalid URL", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to start job", (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String makeContent(Map<String, Object> parameters) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                sb.append(this.escape(key));
                sb.append('=');
                sb.append(this.escape(parameters.get(key).toString()));
                sb.append('&');
            }
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public File getAbsoluteFileInLocalWorkspaceDirectory(String path) {
        return new File(this.downloadJenkinsWorkspace(path), path);
    }

    public class JenkinsOverthereProcess
    implements OverthereProcess {
        private final JenkinsQueueInspector jenkinsQueueInspector;
        private final int timeout;
        private boolean hasExited;
        private int exitCode;

        private JenkinsOverthereProcess(JenkinsQueueInspector jenkinsQueueInspector, int timeout) {
            this.jenkinsQueueInspector = jenkinsQueueInspector;
            this.timeout = timeout;
            this.hasExited = false;
            this.exitCode = -1;
        }

        public OutputStream getStdin() {
            return new ByteArrayOutputStream();
        }

        public InputStream getStdout() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public InputStream getStderr() {
            return new ByteArrayInputStream(new byte[0]);
        }

        public int waitFor() throws InterruptedException {
            if (!this.hasExited) {
                try {
                    this.exitCode = this.jenkinsQueueInspector.waitForJobToFinish(this.timeout);
                }
                catch (Exception e) {
                    throw new RuntimeIOException("Error while waiting for job " + JenkinsConnection.this.jobName + " to finish", (Throwable)e);
                }
                finally {
                    this.hasExited = true;
                }
            }
            return this.exitCode;
        }

        public void destroy() {
            if (!this.hasExited) {
                try {
                    this.jenkinsQueueInspector.stopBuild();
                }
                catch (Exception e) {
                    throw new RuntimeIOException("Unable to force-stop job " + JenkinsConnection.this.jobName, (Throwable)e);
                }
                finally {
                    this.hasExited = true;
                }
            }
        }

        public int exitValue() throws IllegalThreadStateException {
            if (!this.hasExited) {
                try {
                    int status = this.jenkinsQueueInspector.getJobStatus(this.timeout);
                    if (status != -1) {
                        this.exitCode = status;
                        this.hasExited = true;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to determine build status", e);
                }
            }
            return this.exitCode;
        }

        public String getSlaveName() {
            return this.jenkinsQueueInspector.getSlaveName();
        }

        public Number getBuildNumber() {
            return this.jenkinsQueueInspector.getBuildNumber();
        }
    }
}

