/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.net.UrlEscapers;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.xebialabs.xltest.jenkins.JenkinsConnectionException;
import com.xebialabs.xltest.jenkins.JenkinsRequest;
import com.xebialabs.xltest.jenkins.NumberSlavePair;
import com.xebialabs.xltest.jenkins.StatusCodeAndContent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsQueueInspector {
    private static final Logger LOG = LoggerFactory.getLogger((String)JenkinsQueueInspector.class.getName());
    public static final String SUCCESS = "SUCCESS";
    public static final String UNSTABLE = "UNSTABLE";
    public static final int MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final String XL_TEST_RUN_ID = "XL_TEST_RUN_ID";
    public static final int BUILD_SUCCESS = 0;
    public static final int BUILD_UNSTABLE = 1;
    public static final int BUILD_FAILURE = 2;
    public static final int BUILD_TIMEOUT = 3;
    public static final int BUILD_JENKINS_ERROR = 4;
    public static final int BUILD_STILL_RUNNING = -1;
    static final JsonPath BUILD_XLTEST_RESULT = JsonPath.compile((String)"$.result", (Filter[])new Filter[0]);
    private final String uniqueIdParameterName;
    private final String uniqueId;
    private final String jobName;
    private final URL jenkinsBaseUrl;
    private final JenkinsRequest jenkinsRequest;
    private Number buildNumber;
    private String slaveName;
    private int nrOfJobsInQueueRetries = 120;
    private long timeoutTime;

    public JenkinsQueueInspector(URL url, String jobName, String username, String password, String uniqueIdParameterName, String uniqueId) {
        this.jenkinsBaseUrl = url;
        this.jobName = jobName;
        this.uniqueIdParameterName = uniqueIdParameterName;
        this.uniqueId = uniqueId;
        this.jenkinsRequest = Strings.isNullOrEmpty((String)username) ? new JenkinsRequest() : new JenkinsRequest(username, password);
    }

    public JenkinsQueueInspector(URL url, String jobName, JenkinsRequest jenkinsRequest, String uniqueIdParameterName, String uniqueId) {
        this.jenkinsBaseUrl = url;
        this.jobName = jobName;
        this.uniqueIdParameterName = uniqueIdParameterName;
        this.uniqueId = uniqueId;
        this.jenkinsRequest = jenkinsRequest;
    }

    public int inspectNumberOfJobsInBuildQueue() throws Exception {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            StatusCodeAndContent statusCodeAndContent = null;
            for (int retries = this.nrOfJobsInQueueRetries; retries > 0; --retries) {
                statusCodeAndContent = this.jenkinsRequest.httpGetRequest(new URL(this.jenkinsBaseUrl, "queue/api/json"));
                if (statusCodeAndContent.statusCode == 200) {
                    int numberOfItemsInQueue = statusCodeAndContent.pathCount("items");
                    LOG.debug("found {} jobs waiting in the queue", (Object)numberOfItemsInQueue);
                    return numberOfItemsInQueue;
                }
                Thread.sleep(500L);
            }
            if (statusCodeAndContent != null) {
                throw new JenkinsConnectionException("Calling Jenkins failed with statuscode " + statusCodeAndContent.statusCode);
            }
            throw new JenkinsConnectionException("Calling Jenkins failed with unknown statuscode");
        }
    }

    public String getSlaveName() {
        return this.slaveName;
    }

    public Number getBuildNumber() {
        return this.buildNumber;
    }

    public Number getQueueIdForBuildWithXlTestUrl() throws IOException {
        URL url = new URL(this.jenkinsBaseUrl, "queue/api/json?tree=items[id,actions[parameters[*]]]");
        StatusCodeAndContent statusCodeAndContent = this.jenkinsRequest.httpGetRequest(url);
        if (statusCodeAndContent.statusCode != 200) {
            LOG.warn("Calling {} did return status code {}: {}", new Object[]{url, statusCodeAndContent.statusCode, statusCodeAndContent.json});
            return null;
        }
        return this.extractQueueIdFromBuildQueue((Map)statusCodeAndContent.json);
    }

    public boolean cancelQueuedBuild(Number id) throws Exception {
        StatusCodeAndContent statusCodeAndContent = this.jenkinsRequest.httpPostRequest(new URL(this.jenkinsBaseUrl, "queue/cancelItem=" + id));
        return statusCodeAndContent.statusCode < 400;
    }

    public NumberSlavePair getNumberForBuildWithXlTestUrl() throws IOException {
        URL url = new URL(this.jenkinsBaseUrl, "job/" + this.escape(this.jobName) + "/api/json?tree=builds[number,result,url,builtOn,actions[parameters[*]]]");
        StatusCodeAndContent statusCodeAndContent = this.jenkinsRequest.httpGetRequest(url);
        if (statusCodeAndContent.statusCode != 200) {
            LOG.warn("Calling {} did return status code {}: {}", new Object[]{url, statusCodeAndContent.statusCode, statusCodeAndContent.json});
            return null;
        }
        Number buildNumber = this.extractBuildNumberFromJob((Map)statusCodeAndContent.json);
        String slave = this.extractSlaveFromJob((Map)statusCodeAndContent.json);
        return new NumberSlavePair(buildNumber, slave);
    }

    private String escape(String s) throws UnsupportedEncodingException {
        return UrlEscapers.urlFragmentEscaper().escape(s);
    }

    public NumberSlavePair waitForBuildNumber() throws Exception {
        for (int retries = 360; retries > 0; --retries) {
            NumberSlavePair numberSlavePair = this.getBuildNumberAndSlave();
            if (numberSlavePair != null) {
                return numberSlavePair;
            }
            Thread.sleep(5000L);
        }
        LOG.error("Finding Jenkins Job for URL {} failed dramatically. We retried 360 times and now give up", (Object)this.uniqueId);
        return null;
    }

    public NumberSlavePair getBuildNumberAndSlave() throws IOException {
        NumberSlavePair numberSlavePair = this.getNumberForBuildWithXlTestUrl();
        if (numberSlavePair == null || numberSlavePair.getNumber() == null) {
            Number queueIdForBuildWithXlTestUrl = this.getQueueIdForBuildWithXlTestUrl();
            if (queueIdForBuildWithXlTestUrl != null) {
                LOG.debug("Found no Job with XL_TEST_RUN_ID={}. Will retry as we found it in the Queue with id: {}", (Object)this.uniqueId, (Object)queueIdForBuildWithXlTestUrl);
            } else {
                LOG.debug("Found no Job with XL_TEST_RUN_ID={}. It is also not in the Queue. We blame Jenkins. Will retry anyway.", (Object)this.uniqueId);
            }
            return null;
        }
        LOG.debug("Found Job with XL_TEST_RUN_ID={}. It is: {}", (Object)this.uniqueId, (Object)numberSlavePair.getNumber());
        return numberSlavePair;
    }

    public String buildResult() throws IOException {
        URL url = new URL(this.jenkinsBaseUrl, "job/" + this.escape(this.jobName) + "/" + this.buildNumber + "/api/json?tree=number,result");
        StatusCodeAndContent statusCodeAndContent = this.jenkinsRequest.httpGetRequest(url);
        if (statusCodeAndContent.statusCode != 200) {
            LOG.warn("Calling {} did return status code {}: {}", new Object[]{url, statusCodeAndContent.statusCode, statusCodeAndContent.json});
            return null;
        }
        return (String)BUILD_XLTEST_RESULT.read(statusCodeAndContent.json);
    }

    public int waitForJobToFinish(int timeout) throws Exception {
        LOG.info("Job {} for run {} is waiting in the build queue", (Object)this.jobName, (Object)this.uniqueId);
        try {
            String buildResult;
            NumberSlavePair buildNumberSlavePair = this.waitForBuildNumber();
            if (buildNumberSlavePair == null) {
                LOG.error("Jenkins Queue Inspector gave up. No clue what to do here");
                return 4;
            }
            this.buildNumber = buildNumberSlavePair.getNumber();
            this.slaveName = buildNumberSlavePair.getSlave();
            this.timeoutTime = System.currentTimeMillis() + (long)(timeout > 0 ? timeout * 60000 : 3600000);
            if (LOG.isInfoEnabled()) {
                LOG.info("Job {} for run {} with time out {} should finish before {}", new Object[]{this.jobName, this.uniqueId, timeout, new Date(this.timeoutTime)});
            }
            while ((buildResult = this.buildResult()) == null && !this.timedOut()) {
                this.sleepOnIt();
            }
            if (this.timedOut()) {
                LOG.info("Job {} for run {} with time out {} just timed out", new Object[]{this.jobName, this.uniqueId, timeout});
                this.stopBuild();
                return 3;
            }
            if (!SUCCESS.equals(buildResult)) {
                LOG.info("Job {} for run {} did not finish successfully", (Object)this.jobName, (Object)this.uniqueId);
                return 2;
            }
            LOG.info("Job {} for run {} did finish successfully", (Object)this.jobName, (Object)this.uniqueId);
            return 0;
        }
        catch (InterruptedException ie) {
            this.cancelJobOnJenkins();
            throw ie;
        }
    }

    public int getJobStatus(int timeout) throws IOException {
        if (this.buildNumber == null) {
            NumberSlavePair buildNumberSlavePair = this.getBuildNumberAndSlave();
            if (buildNumberSlavePair == null) {
                return -1;
            }
            this.buildNumber = buildNumberSlavePair.getNumber();
            this.slaveName = buildNumberSlavePair.getSlave();
            this.timeoutTime = System.currentTimeMillis() + (long)(timeout > 0 ? timeout * 60000 : 3600000);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Job {} for run {} with time out {} should finish before {}", new Object[]{this.jobName, this.uniqueId, timeout, new Date(this.timeoutTime)});
        }
        String buildResult = this.buildResult();
        if (this.timedOut()) {
            LOG.info("Job {} for run {} with time out {} just timed out", new Object[]{this.jobName, this.uniqueId, timeout});
            this.stopBuild();
            return 3;
        }
        if (buildResult == null) {
            return -1;
        }
        if (SUCCESS.equals(buildResult)) {
            LOG.info("Job {} for run {} did finish successfully", (Object)this.jobName, (Object)this.uniqueId);
            return 0;
        }
        if (UNSTABLE.equals(buildResult)) {
            LOG.info("Job {} for run {} did finish but is unstable", (Object)this.jobName, (Object)this.uniqueId);
            return 1;
        }
        LOG.info("Job {} for run {} did not finish successfully", (Object)this.jobName, (Object)this.uniqueId);
        return 2;
    }

    private boolean timedOut() {
        return System.currentTimeMillis() > this.timeoutTime;
    }

    private void sleepOnIt() throws InterruptedException {
        Thread.sleep(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBuild() throws IOException {
        URL url = new URL(this.jenkinsBaseUrl, "job/" + this.escape(this.jobName) + "/" + this.buildNumber + "/stop");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        try {
            if (conn.getResponseCode() != 200) {
                LOG.warn("Calling {} did return status code {}: {}", new Object[]{url, conn.getResponseCode(), CharStreams.toString((Readable)new InputStreamReader(conn.getInputStream()))});
            }
        }
        finally {
            conn.disconnect();
        }
    }

    protected void cancelJobOnJenkins() {
        Number queueId = null;
        try {
            queueId = this.getQueueIdForBuildWithXlTestUrl();
            if (queueId != null && this.cancelQueuedBuild(queueId)) {
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to remove build {} from queue", (Object)queueId, (Object)e);
        }
        try {
            if (this.buildNumber == null) {
                this.buildNumber = this.waitForBuildNumber().getNumber();
            }
            if (this.buildNumber != null) {
                this.stopBuild();
            }
        }
        catch (Exception e) {
            LOG.error("Unable to stop build {}/{}", new Object[]{this.jobName, this.buildNumber, e});
        }
    }

    Number extractQueueIdFromBuildQueue(Map<String, List<Map<String, Object>>> json) {
        return (Number)this.extractIdFromJenkinsResponse(json, "items", "id");
    }

    Number extractBuildNumberFromJob(Map<String, List<Map<String, Object>>> json) {
        return (Number)this.extractIdFromJenkinsResponse(json, "builds", "number");
    }

    String extractSlaveFromJob(Map<String, List<Map<String, Object>>> json) {
        return (String)this.extractIdFromJenkinsResponse(json, "builds", "builtOn");
    }

    private Object extractIdFromJenkinsResponse(Map<String, List<Map<String, Object>>> builds, String groupName, String idName) {
        for (Map<String, Object> build : builds.get(groupName)) {
            List parameters;
            List actions = (List)build.get("actions");
            if (actions == null || actions.size() == 0 || (parameters = (List)((Map)actions.get(0)).get("parameters")) == null || parameters.size() == 0) continue;
            for (Map parameter : parameters) {
                if (!this.uniqueIdParameterName.equals(parameter.get("name")) || !this.uniqueId.equals(parameter.get("value"))) continue;
                return build.get(idName);
            }
        }
        return null;
    }

    public void setNrOfJobsInQueueRetries(int nrOfJobsInQueueRetries) {
        this.nrOfJobsInQueueRetries = nrOfJobsInQueueRetries;
    }
}

