/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.license.InvalidLicenseException;
import com.xebialabs.license.LicenseProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class License {
    public static final String PRODUCT_DEPLOYIT = "XL Deploy";
    public static final String PRODUCT_OLD_DEPLOYIT = "Deployit";
    public static final String PRODUCT_XL_RELEASE = "XL Release";
    public static final Set<String> PRODUCTS = Sets.newHashSet((Object[])new String[]{"XL Deploy", "XL Release", "Deployit"});
    static final DateTimeFormatter LICENSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Map<LicenseProperty, String> values;

    protected License(Map<LicenseProperty, String> values) {
        this.values = Maps.newHashMap(this.filterLicenseProperties(values));
        this.validateLicenseFormat();
    }

    public abstract List<LicenseProperty> getLicenseProperties();

    public abstract String getLicenseVersion();

    private Map<LicenseProperty, String> filterLicenseProperties(Map<LicenseProperty, String> values) {
        return Maps.filterEntries(values, (Predicate)new Predicate<Map.Entry<LicenseProperty, String>>(){

            public boolean apply(Map.Entry<LicenseProperty, String> input) {
                return input.getValue() != null && !input.getValue().trim().isEmpty();
            }
        });
    }

    protected void validateProperties() {
        for (LicenseProperty property : this.getLicenseProperties()) {
            this.validateRequired(property);
            this.validateValueFormat(property);
        }
    }

    private void validateRequired(LicenseProperty property) {
        if (property.isRequired() && !this.hasLicenseProperty(property)) {
            throw new InvalidLicenseException(this.emptyErrorMessage(property));
        }
    }

    private void validateProduct() {
        String product = this.getStringValue(LicenseProperty.PRODUCT);
        if (!PRODUCTS.contains(product)) {
            throw new InvalidLicenseException(String.format("product should be one of: %s got '%s'", PRODUCTS, product));
        }
    }

    private void validateValueFormat(LicenseProperty property) {
        switch (property.getType()) {
            case DATE: {
                this.parseDateAndValidate(property);
                break;
            }
            case MAP_STRING_INTEGER: {
                this.parseMapOfStringIntegerAndValidate(property);
                break;
            }
            case LIST_OF_STRINGS: {
                this.parseListOfStrings(property);
            }
        }
    }

    public void validateLicenseFormat() {
        this.validateProperties();
        this.validateProduct();
    }

    public boolean isDateExpired() {
        return LocalDate.now().isAfter((ReadablePartial)this.getLocalDateValue(LicenseProperty.EXPIRES_AFTER));
    }

    public String getStringValue(LicenseProperty key) {
        return this.values.get((Object)key);
    }

    public LocalDate getLocalDateValue(LicenseProperty key) {
        return this.parseDateAndValidate(key);
    }

    public Map<String, Integer> getMapValue(LicenseProperty key) {
        return this.parseMapOfStringIntegerAndValidate(key);
    }

    public List<String> getListValue(LicenseProperty key) {
        return this.parseListOfStrings(key);
    }

    public boolean hasLicenseProperty(LicenseProperty key) {
        return this.values.containsKey((Object)key);
    }

    private LocalDate parseDateAndValidate(LicenseProperty property) {
        String propertyValue = this.getStringValue(property);
        try {
            return LocalDate.parse((String)propertyValue, (DateTimeFormatter)LICENSE_DATE_FORMAT);
        }
        catch (Exception e) {
            throw new InvalidLicenseException(this.createErrorMessage(property, propertyValue));
        }
    }

    private Map<String, Integer> parseMapOfStringIntegerAndValidate(LicenseProperty property) {
        String[] pairs;
        String propertyValue = this.getStringValue(property);
        if (propertyValue == null) {
            return null;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String pair : pairs = propertyValue.split(",")) {
            try {
                String[] pairStringInt = pair.trim().split("=");
                Integer intValue = Integer.parseInt(pairStringInt[1].trim());
                String stringValue = pairStringInt[0].trim();
                result.put(stringValue, intValue);
            }
            catch (Exception e) {
                throw new InvalidLicenseException(this.createErrorMessage(property, propertyValue));
            }
        }
        return result;
    }

    private List<String> parseListOfStrings(LicenseProperty property) {
        String[] values;
        String propertyValue = this.getStringValue(property);
        if (propertyValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String val : values = propertyValue.split(",")) {
            result.add(val.trim());
        }
        return result;
    }

    private String createErrorMessage(LicenseProperty property, String propertyValue) {
        return String.format("Unable to parse '%s' '%s'", property.getName().toLowerCase(), propertyValue);
    }

    private String emptyErrorMessage(LicenseProperty property) {
        return String.format("'%s' cannot be empty", property.getName().toLowerCase());
    }

    private String formatAll(String format) {
        return this.formatAllWithProperties(format, this.getLicenseProperties());
    }

    private String formatAllWithProperties(String template, List<LicenseProperty> properties) {
        StringBuilder result = new StringBuilder();
        for (LicenseProperty property : properties) {
            if (!this.hasLicenseProperty(property)) continue;
            result.append(this.format(property, template));
        }
        return result.toString();
    }

    public String toLicenseContent() {
        return this.formatAll("%s: %s%n");
    }

    public String toString() {
        return this.formatAll("%-" + String.valueOf(LicenseProperty.getLongerNameLength()) + "s: %s%n");
    }

    protected String format(LicenseProperty licenseProperty, String template) {
        String value = this.getStringValue(licenseProperty);
        if (value != null) {
            return String.format(template, licenseProperty.getName(), value);
        }
        return null;
    }
}

