/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionSelectionResponder
implements SecureResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        SimpleResponse response = new SimpleResponse();
        String resource = request.getResource();
        WikiPagePath path = PathParser.parse(resource);
        WikiPage page = context.root.getPageCrawler().getPage(path);
        if (page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        PageData pageData = page.getData();
        List<VersionInfo> versions = VersionSelectionResponder.getVersionsList(page);
        HtmlPage html = context.pageFactory.newPage();
        html.setTitle("Version Selection: " + resource);
        html.setPageTitle(new PageTitle("Version Selection", PathParser.parse(resource), pageData.getAttribute("Suites")));
        html.put("versions", versions);
        html.setNavTemplate("viewNav");
        html.put("viewLocation", request.getResource());
        html.setMainTemplate("versionSelection");
        response.setContent(html.html());
        return response;
    }

    public static List<VersionInfo> getVersionsList(WikiPage page) {
        ArrayList<VersionInfo> list = new ArrayList<VersionInfo>(page.getVersions());
        Collections.sort(list);
        Collections.reverse(list);
        return list;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

