/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;
import java.util.Arrays;

public class MakeInstruction
extends Instruction {
    public static final String INSTRUCTION = "make";
    private final String instanceName;
    private final String className;
    private final Object[] args;

    public MakeInstruction(String id, String instanceName, String className) {
        this(id, instanceName, className, new Object[0]);
    }

    public MakeInstruction(String id, String instanceName, String className, Object[] args) {
        super(id);
        this.instanceName = instanceName;
        this.className = className;
        this.args = args;
    }

    @Override
    protected InstructionResult executeInternal(InstructionExecutor executor) throws SlimException {
        executor.create(this.instanceName, this.className, this.args);
        return new InstructionResult.Ok(this.getId());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{id='").append(this.getId()).append('\'');
        sb.append(", instruction='").append(INSTRUCTION).append('\'');
        sb.append(", instanceName='").append(this.instanceName).append('\'');
        sb.append(", className='").append(this.className).append('\'');
        sb.append(", args=").append(this.args == null ? "null" : Arrays.asList(this.args).toString());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MakeInstruction that = (MakeInstruction)o;
        if (!Arrays.equals(this.args, that.args)) {
            return false;
        }
        if (!this.className.equals(that.className)) {
            return false;
        }
        return this.instanceName.equals(that.instanceName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.instanceName.hashCode();
        result = 31 * result + this.className.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }
}

