/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class CompositeTestSystemListener
implements TestSystemListener {
    private final List<TestSystemListener> listeners = new LinkedList<TestSystemListener>();

    public final void addTestSystemListener(TestSystemListener listener) {
        this.listeners.add(listener);
    }

    protected final List<TestSystemListener> listeners() {
        return this.listeners;
    }

    @Override
    public void testSystemStarted(TestSystem testSystem) {
        for (TestSystemListener listener : this.listeners) {
            listener.testSystemStarted(testSystem);
        }
    }

    @Override
    public void testOutputChunk(String output) throws IOException {
        for (TestSystemListener listener : this.listeners) {
            listener.testOutputChunk(output);
        }
    }

    public void testStarted(TestPage testPage) throws IOException {
        for (TestSystemListener listener : this.listeners) {
            listener.testStarted(testPage);
        }
    }

    public void testComplete(TestPage testPage, TestSummary testSummary) throws IOException {
        for (TestSystemListener listener : this.listeners) {
            listener.testComplete(testPage, testSummary);
        }
    }

    @Override
    public void testSystemStopped(TestSystem testSystem, Throwable cause) {
        for (TestSystemListener listener : this.listeners) {
            listener.testSystemStopped(testSystem, cause);
        }
    }

    @Override
    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
        for (TestSystemListener listener : this.listeners) {
            listener.testAssertionVerified(assertion, testResult);
        }
    }

    @Override
    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
        for (TestSystemListener listener : this.listeners) {
            listener.testExceptionOccurred(assertion, exceptionResult);
        }
    }
}

