/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.results;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestResult;

public class SlimTestResult
implements TestResult {
    private final String actual;
    private final String expected;
    private final ExecutionResult executionResult;
    private final String message;
    private final boolean counts;

    public SlimTestResult(ExecutionResult executionResult) {
        this(null, null, null, executionResult, true);
    }

    protected SlimTestResult(String actual, String expected, String message, ExecutionResult executionResult) {
        this(actual, expected, message, executionResult, true);
    }

    protected SlimTestResult(String actual, String expected, String message, ExecutionResult executionResult, boolean counts) {
        this.actual = actual;
        this.expected = expected;
        this.message = message;
        this.executionResult = executionResult;
        this.counts = counts;
    }

    @Override
    public boolean doesCount() {
        return this.counts;
    }

    @Override
    public boolean hasActual() {
        return this.actual != null;
    }

    @Override
    public String getActual() {
        return this.actual;
    }

    @Override
    public boolean hasExpected() {
        return this.expected != null;
    }

    @Override
    public String getExpected() {
        return this.expected;
    }

    @Override
    public boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public SlimTestResult negateTestResult() {
        ExecutionResult newExecutionResult = this.executionResult == ExecutionResult.PASS ? ExecutionResult.FAIL : (this.executionResult == ExecutionResult.FAIL ? ExecutionResult.PASS : this.executionResult);
        return new SlimTestResult(this.actual, this.expected, this.message, newExecutionResult);
    }

    public String toString(String originalContent) {
        StringBuilder builder = new StringBuilder();
        if (this.executionResult != null) {
            builder.append(this.executionResult.toString()).append('(');
        }
        if (this.hasActual()) {
            builder.append("a=").append(this.getActual());
            if (this.hasExpected() || this.hasMessage()) {
                builder.append(";");
            }
        }
        if (this.hasExpected()) {
            builder.append("e=").append(this.getExpected());
            if (this.hasMessage()) {
                builder.append(";");
            }
        }
        if (this.hasMessage()) {
            builder.append(this.getMessage());
        } else if (!this.hasActual() && !this.hasExpected()) {
            builder.append(originalContent);
        }
        if (this.executionResult != null) {
            builder.append(')');
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public static SlimTestResult pass() {
        return new SlimTestResult(ExecutionResult.PASS);
    }

    public static SlimTestResult pass(String message) {
        return new SlimTestResult(null, null, message, ExecutionResult.PASS);
    }

    public static TestResult pass(String actual, String expected) {
        return new SlimTestResult(actual, expected, null, ExecutionResult.PASS);
    }

    public static SlimTestResult fail() {
        return new SlimTestResult(null, null, null, ExecutionResult.FAIL);
    }

    public static SlimTestResult fail(String message) {
        return new SlimTestResult(null, null, message, ExecutionResult.FAIL);
    }

    public static SlimTestResult fail(String actual, String expected) {
        return new SlimTestResult(actual, expected, null, ExecutionResult.FAIL);
    }

    public static SlimTestResult fail(String actual, String expected, String message) {
        return new SlimTestResult(actual, expected, message, ExecutionResult.FAIL);
    }

    public static SlimTestResult ignore() {
        return new SlimTestResult(ExecutionResult.IGNORE);
    }

    public static SlimTestResult ignore(String message) {
        return new SlimTestResult(null, null, message, ExecutionResult.IGNORE);
    }

    public static SlimTestResult error(String message) {
        return new SlimTestResult(null, null, message, ExecutionResult.ERROR);
    }

    public static SlimTestResult error(String message, String actual) {
        return new SlimTestResult(actual, null, message, ExecutionResult.ERROR);
    }

    public static SlimTestResult plain() {
        return new SlimTestResult(null, null, null, null);
    }

    public static SlimTestResult plain(String message) {
        return new SlimTestResult(null, null, message, null);
    }

    public static SlimTestResult ok(String message) {
        return new SlimTestResult(null, null, message, ExecutionResult.PASS, false);
    }

    public static SlimTestResult testNotRun() {
        return new SlimTestResult(null, null, "Test not run", ExecutionResult.IGNORE, false);
    }
}

