/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.testrunner.WikiTestPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikitextPage;
import fitnesse.wikitext.parser.See;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WikiPageUtil {
    public static void setPageContents(WikiPage page, String pageContents) {
        PageData pageData = page.getData();
        pageData.setContent(pageContents);
        page.commit(pageData);
    }

    public static WikiPage getHeaderPage(WikiPage wikiPage) {
        return wikiPage.getPageCrawler().getClosestInheritedPage("PageHeader");
    }

    public static WikiPage getFooterPage(WikiPage wikiPage) {
        return wikiPage.getPageCrawler().getClosestInheritedPage("PageFooter");
    }

    public static String getHeaderPageHtml(WikiPage wikiPage) {
        WikiPage header = WikiPageUtil.getHeaderPage(wikiPage);
        return header == null ? "" : header.getHtml();
    }

    public static String getFooterPageHtml(WikiPage wikiPage) {
        WikiPage footer = WikiPageUtil.getFooterPage(wikiPage);
        return footer == null ? "" : footer.getHtml();
    }

    public static WikiPage addPage(WikiPage context, WikiPagePath path, String content) {
        WikiPage page = WikiPageUtil.addPage(context, path);
        if (page != null) {
            PageData data = new PageData(page.getData(), content);
            page.commit(data);
        }
        return page;
    }

    public static WikiPage addPage(WikiPage context, WikiPagePath path) {
        return WikiPageUtil.getOrMakePage(context, path.getNames());
    }

    private static WikiPage getOrMakePage(WikiPage context, List<?> namePieces) {
        String first = (String)namePieces.get(0);
        List<?> rest = namePieces.subList(1, namePieces.size());
        WikiPage current = context.getChildPage(first) == null ? context.addChildPage(first) : context.getChildPage(first);
        if (rest.size() == 0) {
            return current;
        }
        return WikiPageUtil.getOrMakePage(current, rest);
    }

    public static String makePageHtml(WikiPage page) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WikiPageUtil.getHeaderPageHtml(page));
        buffer.append(page.getHtml());
        return buffer.toString();
    }

    public static String makePageHtml(WikiTestPage page) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WikiPageUtil.getHeaderPageHtml(page.getSourcePage()));
        buffer.append(page.getHtml());
        return buffer.toString();
    }

    public static File resolveFileUri(String fullPageURI, File rootPath) {
        URI uri = URI.create(fullPageURI);
        try {
            return new File(uri);
        }
        catch (IllegalArgumentException e) {
            if (!"file".equals(uri.getScheme()) || rootPath == null) {
                throw e;
            }
            URI rootUri = rootPath.toURI();
            uri = rootUri.resolve(uri.getSchemeSpecificPart().replaceFirst("^/+", ""));
            return new File(uri);
        }
    }

    public static List<String> getXrefPages(WikiPage page) {
        if (page instanceof WikitextPage) {
            final ArrayList<String> xrefPages = new ArrayList<String>();
            ((WikitextPage)((Object)page)).getSyntaxTree().walkPreOrder(new SymbolTreeWalker(){

                @Override
                public boolean visit(Symbol node) {
                    if (node.isType(See.symbolType)) {
                        xrefPages.add(node.childAt(0).getContent());
                    }
                    return true;
                }

                @Override
                public boolean visitChildren(Symbol node) {
                    return true;
                }
            });
            return xrefPages;
        }
        return Collections.emptyList();
    }
}

