/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.ConfigurationParameter;
import fitnesse.components.ComponentFactory;
import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.VariableTool;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.WikiPageFactoryRegistry;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiPageUtil;
import fitnesse.wiki.fs.DiskFileSystem;
import fitnesse.wiki.fs.ExternalSuitePageFactory;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.SubWikiPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.ZipFileVersionsController;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiWordPath;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import util.Maybe;

public class FileSystemPageFactory
implements WikiPageFactory<FileSystemPage>,
WikiPageFactoryRegistry {
    private final FileSystem fileSystem;
    private final VersionsController versionsController;
    private final VariableSource variableSource;
    private final List<WikiPageFactory> wikiPageFactories = new ArrayList<WikiPageFactory>();

    public FileSystemPageFactory() {
        this.fileSystem = new DiskFileSystem();
        this.versionsController = new ZipFileVersionsController();
        this.variableSource = new SystemVariableSource(new Properties());
        this.initializeWikiPageFactories();
    }

    public FileSystemPageFactory(Properties properties) {
        this.fileSystem = new DiskFileSystem();
        this.versionsController = (VersionsController)new ComponentFactory(properties).createComponent(ConfigurationParameter.VERSIONS_CONTROLLER_CLASS, ZipFileVersionsController.class);
        this.versionsController.setHistoryDepth(Integer.parseInt(properties.getProperty(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS.getKey(), "14")));
        this.variableSource = new SystemVariableSource(properties);
        this.initializeWikiPageFactories();
    }

    public FileSystemPageFactory(FileSystem fileSystem, VersionsController versionsController, VariableSource variableSource) {
        this.fileSystem = fileSystem;
        this.versionsController = versionsController;
        this.variableSource = variableSource;
        this.initializeWikiPageFactories();
    }

    private void initializeWikiPageFactories() {
        this.registerWikiPageFactory(this);
        this.registerWikiPageFactory(new ExternalSuitePageFactory(this.fileSystem, this.variableSource));
    }

    @Override
    public void registerWikiPageFactory(WikiPageFactory wikiPageFactory) {
        this.wikiPageFactories.add(wikiPageFactory);
    }

    @Override
    public boolean supports(File path) {
        for (String child : this.fileSystem.list(path)) {
            if (!child.equals("content.txt")) continue;
            return true;
        }
        return false;
    }

    public FileSystemPage makePage(File path, String pageName, FileSystemPage parent) {
        if (parent != null) {
            return new FileSystemPage(path, pageName, parent);
        }
        Maybe<String> rootPath = this.variableSource.findVariable("FITNESSE_ROOTPATH");
        return new FileSystemPage(path, pageName, this.versionsController, new FileSystemSubWikiPageFactory(new File(rootPath.getValue())), this.variableSource);
    }

    VersionsController getVersionsController() {
        return this.versionsController;
    }

    private WikiPage makeChildPage(File path, String childName, FileSystemPage page) {
        for (WikiPageFactory factory : this.wikiPageFactories) {
            if (!factory.supports(path)) continue;
            return factory.makePage(path, childName, page);
        }
        if (this.fileIsValid(path)) {
            return this.makePage(path, childName, page);
        }
        return null;
    }

    private boolean fileIsValid(File path) {
        return WikiWordPath.isWikiWord(path.getName()) && this.fileSystem.exists(path);
    }

    protected class FileSystemSubWikiPageFactory
    implements SubWikiPageFactory {
        private final File rootPath;

        public FileSystemSubWikiPageFactory(File rootPath) {
            this.rootPath = rootPath;
        }

        @Override
        public List<WikiPage> getChildren(FileSystemPage page) {
            List<WikiPage> children = this.getNormalChildren(page);
            children.addAll(this.getSymlinkChildren(page));
            return children;
        }

        private List<WikiPage> getNormalChildren(FileSystemPage page) {
            File thisDir = page.getFileSystemPath();
            LinkedList<WikiPage> children = new LinkedList<WikiPage>();
            if (FileSystemPageFactory.this.fileSystem.exists(thisDir)) {
                String[] subFiles;
                for (String subFile : subFiles = FileSystemPageFactory.this.fileSystem.list(thisDir)) {
                    if (!FileSystemPageFactory.this.fileIsValid(new File(thisDir, subFile))) continue;
                    children.add(this.getChildPage(page, subFile));
                }
            }
            return children;
        }

        protected List<WikiPage> getSymlinkChildren(BaseWikiPage page) {
            LinkedList<WikiPage> children = new LinkedList<WikiPage>();
            WikiPageProperties props = page.getData().getProperties();
            WikiPageProperty symLinksProperty = props.getProperty("SymbolicLinks");
            if (symLinksProperty != null) {
                for (String linkName : symLinksProperty.keySet()) {
                    WikiPage linkedPage = this.createSymbolicPage(page, linkName);
                    if (linkedPage == null || children.contains(linkedPage)) continue;
                    children.add(linkedPage);
                }
            }
            return children;
        }

        @Override
        public WikiPage getChildPage(FileSystemPage page, String childName) {
            File parent = page.getFileSystemPath();
            WikiPage childPage = FileSystemPageFactory.this.makeChildPage(new File(parent, childName), childName, page);
            if (childPage == null) {
                childPage = this.createSymbolicPage(page, childName);
            }
            return childPage;
        }

        private WikiPage createSymbolicPage(BaseWikiPage page, String linkName) {
            WikiPageProperty symLinkProperty = page.getData().getProperties().getProperty("SymbolicLinks");
            if (symLinkProperty == null) {
                return null;
            }
            String linkPath = symLinkProperty.get(linkName);
            if (linkPath == null) {
                return null;
            }
            if (linkPath.startsWith("file:")) {
                return this.createExternalSymbolicLink(linkPath, linkName, page);
            }
            return this.createInternalSymbolicPage(linkPath, linkName, page);
        }

        private WikiPage createExternalSymbolicLink(String linkPath, String linkName, BaseWikiPage parent) {
            WikiPage externalRoot;
            String fullPagePath = new VariableTool(FileSystemPageFactory.this.variableSource).replace(linkPath);
            File file = WikiPageUtil.resolveFileUri(fullPagePath, this.rootPath);
            File parentDirectory = file.getParentFile();
            if (FileSystemPageFactory.this.fileSystem.exists(parentDirectory) && (externalRoot = FileSystemPageFactory.this.makeChildPage(file, file.getName(), null)) != null) {
                return new SymbolicPage(linkName, externalRoot, parent);
            }
            return null;
        }

        protected WikiPage createInternalSymbolicPage(String linkPath, String linkName, BaseWikiPage parent) {
            WikiPagePath path = PathParser.parse(linkPath);
            if (path == null) {
                return null;
            }
            WikiPage start = path.isRelativePath() ? parent.getParent() : parent;
            WikiPage wikiPage = start.getPageCrawler().getPage(path);
            if (wikiPage != null) {
                wikiPage = new SymbolicPage(linkName, wikiPage, parent);
            }
            return wikiPage;
        }
    }
}

