/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.search;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.search.WikiPageFinder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuiteSpecificationMatchFinder
extends WikiPageFinder {
    private String titleRegEx;
    private String contentRegEx;

    public SuiteSpecificationMatchFinder(String titleRegEx, String contentRegEx, TraversalListener<? super WikiPage> observer) {
        super(observer);
        this.titleRegEx = titleRegEx;
        this.contentRegEx = contentRegEx;
    }

    @Override
    protected boolean pageMatches(WikiPage page) {
        if (!this.nullOrEmpty(this.titleRegEx) && !this.nullOrEmpty(this.contentRegEx)) {
            return this.patternMatches(this.titleRegEx, page.getName()) && this.patternMatches(this.contentRegEx, page.getData().getContent());
        }
        return this.patternMatches(this.titleRegEx, page.getName()) || this.patternMatches(this.contentRegEx, page.getData().getContent());
    }

    private boolean patternMatches(String regEx, String subject) {
        Pattern pattern;
        Matcher matcher;
        return !this.nullOrEmpty(regEx) && (matcher = (pattern = Pattern.compile(regEx, 32)).matcher(subject)).find();
    }

    private boolean nullOrEmpty(String regEx) {
        return regEx == null || regEx.equals("");
    }
}

