/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.VariableSource;
import java.util.HashMap;
import util.Maybe;

public class ParsingPage
implements VariableSource {
    private final SourcePage page;
    private final SourcePage namedPage;
    private final VariableSource variableSource;
    private final HashMap<String, HashMap<String, Maybe<String>>> cache;

    public ParsingPage(SourcePage page) {
        this(page, null);
    }

    public ParsingPage(SourcePage page, VariableSource variableSource) {
        this(page, page, variableSource, new HashMap<String, HashMap<String, Maybe<String>>>());
    }

    public ParsingPage copy() {
        return new ParsingPage(this.page, this.page, this.variableSource, this.cache);
    }

    public ParsingPage copyForPage(SourcePage page) {
        return new ParsingPage(page, page, this.variableSource, this.cache);
    }

    public ParsingPage copyForNamedPage(SourcePage namedPage) {
        return new ParsingPage(this.page, namedPage, this.variableSource, this.cache);
    }

    private ParsingPage(SourcePage page, SourcePage namedPage, VariableSource variableSource, HashMap<String, HashMap<String, Maybe<String>>> cache) {
        this.page = page;
        this.namedPage = namedPage;
        this.variableSource = variableSource;
        this.cache = cache;
    }

    public SourcePage getPage() {
        return this.page;
    }

    public SourcePage getNamedPage() {
        return this.namedPage;
    }

    private boolean inCache(SourcePage page) {
        return this.cache.containsKey(page.getFullName());
    }

    private Maybe<String> findVariableInCache(SourcePage page, String name) {
        String key = page.getFullName();
        if (!this.cache.containsKey(key)) {
            return Maybe.noString;
        }
        if (!this.cache.get(key).containsKey(name)) {
            return Maybe.noString;
        }
        return this.cache.get(key).get(name);
    }

    private Maybe<String> findVariableInCache(String name) {
        return this.findVariableInCache(this.page, name);
    }

    private void putVariable(SourcePage page, String name, Maybe<String> value) {
        String key = page.getFullName();
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new HashMap());
        }
        this.cache.get(key).put(name, value);
    }

    public void putVariable(String name, String value) {
        this.putVariable(this.page, name, new Maybe<String>(value));
    }

    @Override
    public Maybe<String> findVariable(String name) {
        Maybe<String> result = this.findSpecialVariableValue(name);
        if (!result.isNothing()) {
            return result;
        }
        result = this.findVariableInPages(name);
        if (!result.isNothing()) {
            return result;
        }
        return this.findVariableInContext(name);
    }

    private Maybe<String> findSpecialVariableValue(String key) {
        String value;
        if (key.equals("RUNNING_PAGE_NAME")) {
            value = this.page.getName();
        } else if (key.equals("RUNNING_PAGE_PATH")) {
            value = this.page.getPath();
        } else if (key.equals("PAGE_NAME")) {
            value = this.namedPage.getName();
        } else if (key.equals("PAGE_PATH")) {
            value = this.namedPage.getPath();
        } else if (key.equals("FITNESSE_PORT")) {
            Maybe<String> port = this.findVariableInContext("FITNESSE_PORT");
            value = port.isNothing() ? "-1" : port.getValue();
        } else if (key.equals("FITNESSE_ROOTPATH")) {
            Maybe<String> path = this.findVariableInContext("FITNESSE_ROOTPATH");
            value = path.isNothing() ? "" : path.getValue();
        } else if (key.equals("FITNESSE_VERSION")) {
            Maybe<String> version = this.findVariableInContext("FITNESSE_VERSION");
            value = version.isNothing() ? "" : version.getValue();
        } else {
            return Maybe.noString;
        }
        return new Maybe<String>(value);
    }

    private Maybe<String> findVariableInPages(String name) {
        Maybe<String> localVariable = this.findVariableInCache(name);
        if (!localVariable.isNothing()) {
            return new Maybe<String>(localVariable.getValue());
        }
        return this.lookInParentPages(name);
    }

    private Maybe<String> findVariableInContext(String name) {
        return this.variableSource != null ? this.variableSource.findVariable(name) : Maybe.noString;
    }

    private Maybe<String> lookInParentPages(String name) {
        for (SourcePage sourcePage : this.page.getAncestors()) {
            Maybe<String> result;
            if (!this.inCache(sourcePage)) {
                Parser.make(this.copyForPage(sourcePage), sourcePage.getContent()).parse();
                this.putVariable(sourcePage, "", Maybe.noString);
            }
            if ((result = this.findVariableInCache(sourcePage, name)).isNothing()) continue;
            return result;
        }
        return Maybe.noString;
    }
}

