/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import util.Clock;
import util.Maybe;

public class Today
extends SymbolType
implements Rule,
Translation {
    private static final String Format = "Format";
    private static final String Increment = "Increment";
    private final int incrementUnit;

    public Today() {
        this("Today", "!today", 5);
    }

    protected Today(String symbolName, String symbolText, int unitForIncrement) {
        super(symbolName);
        this.incrementUnit = unitForIncrement;
        this.wikiMatcher(new Matcher().string(symbolText));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        List<Symbol> lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.Text});
        if (lookAhead.size() != 0) {
            String option = lookAhead.get(1).getContent();
            if (this.isDateFormatOption(option)) {
                current.putProperty(Format, option);
                parser.moveNext(2);
            }
        } else {
            lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.OpenParenthesis});
            if (lookAhead.size() != 0) {
                parser.moveNext(2);
                Maybe<String> format = parser.parseToAsString(SymbolType.CloseParenthesis);
                if (format.isNothing()) {
                    return Symbol.nothing;
                }
                current.putProperty(Format, format.getValue());
            }
        }
        lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.Delta});
        if (lookAhead.size() != 0) {
            String increment = lookAhead.get(1).getContent();
            current.putProperty(Increment, increment);
            parser.moveNext(2);
        }
        return new Maybe<Symbol>(current);
    }

    private boolean isDateFormatOption(String option) {
        return option.equals("-t") || option.equals("-xml");
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        String increment = symbol.getProperty(Increment);
        int incrementInt = increment.startsWith("+") ? Integer.parseInt(increment.substring(1)) : (increment.startsWith("-") ? -Integer.parseInt(increment.substring(1)) : 0);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(Clock.currentDate());
        this.addIncrement(calendar, incrementInt);
        return new SimpleDateFormat(this.makeFormat(symbol.getProperty(Format))).format(calendar.getTime());
    }

    protected void addIncrement(GregorianCalendar calendar, int increment) {
        calendar.add(this.incrementUnit, increment);
    }

    private String makeFormat(String format) {
        return format.equals("-t") ? "dd MMM, yyyy HH:mm" : (format.equals("-xml") ? "yyyy-MM-dd'T'HH:mm:ss" : (format.length() == 0 ? "dd MMM, yyyy" : format));
    }
}

