import java.util.Date as Date
import java.lang.Long as Long
import java.util.Collections as Collections

run_times = []
completed_requests = []
failed_requests = []
mean_response_time = []
test_name = ''


previousRuns = testRuns.getPreviousRuns(testRun, 9)
if previousRuns:
    Collections.reverse(previousRuns)
    for prevRun in previousRuns:
        events = prevRun.getEvents()
        for ev in events:
            if ev.type == 'executionStarted':
                run_times.append(Date(Long(ev.get('timestamp'))))
            if ev.type == 'performanceResult':
                completed_requests.append(ev.get('numberOfRequests.ok'))
                failed_requests.append(ev.get('numberOfRequests.ko'))
                mean_response_time.append(ev.get('meanResponseTime.total'))

events = testRun.getEvents()
for ev in events:
    if ev.type == 'executionStarted':
        run_times.append(Date(Long(ev.get('timestamp'))))
        test_name = ev.get('simulationName')
    if ev.type == 'performanceResult':
        completed_requests.append(ev.get('numberOfRequests.ok'))
        failed_requests.append(ev.get('numberOfRequests.ko'))
        mean_response_time.append(ev.get('meanResponseTime.total'))

report_data_1 = {
    'chart': {
        'zoomType': 'xy'
    },
    'title': {
        'text':  'Load Test Trends - ' + test_name
    },
    'xAxis': [{
                  'type': 'datetime',
                  'categories': run_times
              }],
    'yAxis': [{  # Secondary yAxis
                 'title': {
                     'text': 'Mean response time',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'labels': {
                     'format': '{value} ms',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'opposite': True
              },
        {  # Primary yAxis
                 'labels': {
                     'format': '{value}',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'title': {
                     'text': 'Number of Requests',
                     'style': {
                         'color': '#003300'
                     }
                 },
                 'stackLabels': {
                     'enabled': True,
                     'style': {
                         'fontWeight': 'bold',
                         'color': 'gray'
                     }
                 }
              }],
    'tooltip': {
        'shared': True
    },
    'plotOptions': {
        'column': {
            'stacking': 'normal',
            'dataLabels': {
                'enabled': True,
                'color': 'white',
                'style': {
                    'textShadow': '0 0 3px black, 0 0 3px black'
                }
            }
        }
    },
    'legend': {
        'layout': 'vertical',
        'align': 'left',
        'x': 120,
        'verticalAlign': 'top',
        'y': 0,
        'floating': True,
        'backgroundColor': '#FFFFFF'
    },
    'series': [{
                   'name': 'completed requests',
                   'type': 'column',
                   'yAxis': 1,
                   'data': completed_requests

               },
               {
                   'name': 'failed requests',
                   'type': 'column',
                   'yAxis': 1,
                   'data': failed_requests

               },
               {
                   'name': 'mean response time',
                   'type': 'spline',
                   'data': mean_response_time,
                   'tooltip': {
                       'valueSuffix': 'ms'
                   }
               }]
}

resultHolder.setResult(report_data_1)
