package com.xebialabs.xltest.utils;

import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class Executor {

    private static final Logger LOG = LoggerFactory.getLogger(Executor.class.getName());
    public static final int MINUTE = 60 * 1000;

    public static int execute(Process process, final int timeout) throws InterruptedException, TimeoutException {
        // models a process.waitFor(timeout) where timeout is in seconds
        /* Set up process I/O is not done here. Do we need that? */
        Worker worker = new Worker(process);
        worker.start();
        try {
            worker.join(timeout * MINUTE);
            if (worker.exit != null) {
                LOG.info("Worker process exited with code {}", worker.exit);
                return worker.exit;
            } else {
                LOG.info("Worker timed out");
                throw new TimeoutException();
            }
        } catch (InterruptedException ex) {
            LOG.info("Worker has been interrupted");
            worker.interrupt();
            Thread.currentThread().interrupt();
            throw ex;
        } finally {
            LOG.info("Attempting to destroy the finished process {}", process);
            process.destroy();
            LOG.info("Worker process {} destroyed", process);
        }
    }

    private static class Worker extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        public void run() {
            try {
                LOG.info("waiting for process {} to finish", process);
                exit = process.waitFor();
            } catch (InterruptedException ignore) {
                LOG.info("process execution is interrupted");
                return;
            }
        }
    }

}
