package com.xebialabs.xltest.utils.glob;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.overthere.OverthereFile;

public class Globbit {
    private final static Logger LOG = LoggerFactory.getLogger(Globbit.class);

    public static Collection<OverthereFile> find(OverthereFile searchRoot, FileMatcher fileMatcher) {
        return matchingFiles(searchRoot, fileMatcher);
    }

    /**
     * Walks a directory structure depth-first and returns a flat list of all matches
     *
     * @param file    Starting point of the directory walk
     * @param matcher
     * @return Flattened list of all matching descendents of file.
     */
    private static List<OverthereFile> matchingFiles(OverthereFile file, FileMatcher matcher) {
        List<OverthereFile> all = getPathTree(file);
        List<OverthereFile> matched = new ArrayList<>();

        for (OverthereFile s : all) {
            String relativePath = s.getPath().replaceFirst(file.getPath() + file.getConnection().getHostOperatingSystem().getFileSeparator(), "");
            if (matcher.match(relativePath)) {
                matched.add(s);
            }
        }

        return matched;
    }


    private static List<OverthereFile> getPathTree(OverthereFile file) {
        if (!file.isDirectory()) {
            return Collections.singletonList(file);
        } else {
            List<OverthereFile> result = new ArrayList<>();
            result.add(file);
            for (OverthereFile child : file.listFiles()) {
                result.addAll(getPathTree(child));
            }
            return result;
        }
    }
}
