/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.samskivert.mustache.MustacheException;
import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholders;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class MustachePlaceholderReplacer {
    public static final String IGNORE_PLACEHOLDER = "<ignore>";
    public static final String EMPTY_PLACEHOLDER = "<empty>";
    private final Map<String, ?> values;
    private final boolean interpretSpecialValues;

    public MustachePlaceholderReplacer(Map<String, ?> values) {
        this(values, true);
    }

    public MustachePlaceholderReplacer(Map<String, ?> values, boolean interpretSpecialValues) {
        this.interpretSpecialValues = interpretSpecialValues;
        this.values = new ReplacerMap(values);
    }

    public StringValue replace(StringValue replaceable) throws DictionaryValueException {
        try {
            EncryptionDetectionMap encryptionDetector = new EncryptionDetectionMap(this.values);
            String execute = MustachePlaceholders.newMustacheCompiler().compile(replaceable.toString()).execute((Object)encryptionDetector);
            if (encryptionDetector.wasEncrypted || replaceable instanceof EncryptedStringValue) {
                return new EncryptedStringValue(execute);
            }
            return new StringValue(execute);
        }
        catch (MustacheException me) {
            throw new DictionaryValueException(me, "Could not replace dictionary keys in %s", replaceable);
        }
    }

    public StringValue replace(String replaceable) throws DictionaryValueException {
        return this.replace(new StringValue(replaceable));
    }

    public void replace(Reader in, Writer out) {
        MustachePlaceholders.newMustacheCompiler().compile(in).execute(this.values, out);
    }

    public void replace(Reader in, Writer out, String delimiters) {
        MustachePlaceholders.newMustacheCompiler().withDelims(delimiters).compile(in).execute(this.values, out);
    }

    private class ReplacerMap
    extends HashMap<String, Object> {
        public ReplacerMap(Map<String, ?> map) {
            super(map);
        }

        @Override
        public Object get(Object o) {
            Object s = super.get(o);
            if (MustachePlaceholderReplacer.this.interpretSpecialValues) {
                if (MustachePlaceholderReplacer.IGNORE_PLACEHOLDER.equals(s)) {
                    return "{{" + o + "}}";
                }
                if (MustachePlaceholderReplacer.EMPTY_PLACEHOLDER.equals(s)) {
                    return "";
                }
            }
            return s;
        }
    }

    private class EncryptionDetectionMap
    extends ReplacerMap {
        boolean wasEncrypted;

        public EncryptionDetectionMap(Map<String, ?> map) {
            super(map);
            this.wasEncrypted = false;
        }

        @Override
        public Object get(Object o) {
            Object get = super.get(o);
            if (get instanceof EncryptedStringValue) {
                this.wasEncrypted = true;
            }
            return get;
        }
    }
}

