/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.RestStatus;

public final class ExceptionsHelper {
    private static final ESLogger logger = Loggers.getLogger(ExceptionsHelper.class);

    public static RuntimeException convertToRuntime(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new ElasticsearchException(t.getMessage(), t);
    }

    public static ElasticsearchException convertToElastic(Throwable t) {
        if (t instanceof ElasticsearchException) {
            return (ElasticsearchException)t;
        }
        return new ElasticsearchException(t.getMessage(), t);
    }

    public static RestStatus status(Throwable t) {
        if (t instanceof ElasticsearchException) {
            return ((ElasticsearchException)t).status();
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public static Throwable unwrapCause(Throwable t) {
        int counter = 0;
        Throwable result = t;
        while (result instanceof ElasticsearchWrapperException) {
            if (result.getCause() == null) {
                return result;
            }
            if (result.getCause() == result) {
                return result;
            }
            if (counter++ > 10) {
                logger.warn("Exception cause unwrapping ran for 10 levels...", t, new Object[0]);
                return result;
            }
            result = result.getCause();
        }
        return result;
    }

    public static String detailedMessage(Throwable t) {
        return ExceptionsHelper.detailedMessage(t, false, 0);
    }

    public static String detailedMessage(Throwable t, boolean newLines, int initialCounter) {
        if (t == null) {
            return "Unknown";
        }
        int counter = initialCounter + 1;
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                if (!newLines) {
                    sb.append("; ");
                }
                if ((t = t.getCause()) != null) {
                    if (newLines) {
                        sb.append("\n");
                        for (int i = 0; i < counter; ++i) {
                            sb.append("\t");
                        }
                    } else {
                        sb.append("nested: ");
                    }
                }
                ++counter;
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }

    public static String stackTrace(Throwable e) {
        StringWriter stackTraceStringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceStringWriter);
        e.printStackTrace(printWriter);
        return stackTraceStringWriter.toString();
    }

    public static <T extends Throwable> void rethrowAndSuppress(List<T> exceptions) throws T {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            if (main == null) {
                main = ex;
                continue;
            }
            main.addSuppressed(ex);
        }
        if (main != null) {
            throw main;
        }
    }

    public static <T extends Throwable> T unwrap(Throwable t, Class<T> clazz) {
        if (t != null) {
            do {
                if (!clazz.isInstance(t)) continue;
                return (T)((Throwable)clazz.cast(t));
            } while ((t = t.getCause()) != null);
        }
        return null;
    }

    public static boolean isOOM(Throwable t) {
        return t != null && (t instanceof OutOfMemoryError || t instanceof IllegalStateException && t.getMessage() != null && t.getMessage().contains("OutOfMemoryError"));
    }
}

