/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.StandardHtmlStripAnalyzer;
import org.elasticsearch.index.settings.IndexSettings;

public class StandardHtmlStripAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StandardHtmlStripAnalyzer> {
    private final StandardHtmlStripAnalyzer analyzer;
    private final Version esVersion;

    @Inject
    public StandardHtmlStripAnalyzerProvider(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.esVersion = indexSettings.getAsVersion("index.version.created", Version.CURRENT);
        CharArraySet defaultStopwords = this.esVersion.onOrAfter(Version.V_1_0_0_RC1) ? CharArraySet.EMPTY_SET : StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        CharArraySet stopWords = Analysis.parseStopWords(env, settings, defaultStopwords, this.version);
        this.analyzer = new StandardHtmlStripAnalyzer(this.version, stopWords);
    }

    @Override
    public StandardHtmlStripAnalyzer get() {
        return this.analyzer;
    }
}

