/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.functionscore.DecayFunctionParser;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.search.MultiValueMode;

public abstract class DecayFunctionBuilder
implements ScoreFunctionBuilder {
    protected static final String ORIGIN = "origin";
    protected static final String SCALE = "scale";
    protected static final String DECAY = "decay";
    protected static final String OFFSET = "offset";
    private String fieldName;
    private Object origin;
    private Object scale;
    private double decay = -1.0;
    private Object offset;
    private MultiValueMode multiValueMode = null;

    public DecayFunctionBuilder(String fieldName, Object origin, Object scale) {
        this.fieldName = fieldName;
        this.origin = origin;
        this.scale = scale;
    }

    public DecayFunctionBuilder setDecay(double decay) {
        if (decay <= 0.0 || decay >= 1.0) {
            throw new ElasticsearchIllegalStateException("scale weight parameter must be in range 0..1!");
        }
        this.decay = decay;
        return this;
    }

    public DecayFunctionBuilder setOffset(Object offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.startObject(this.fieldName);
        if (this.origin != null) {
            builder.field(ORIGIN, this.origin);
        }
        builder.field(SCALE, this.scale);
        if (this.decay > 0.0) {
            builder.field(DECAY, this.decay);
        }
        if (this.offset != null) {
            builder.field(OFFSET, this.offset);
        }
        builder.endObject();
        if (this.multiValueMode != null) {
            builder.field(DecayFunctionParser.MULTI_VALUE_MODE.getPreferredName(), this.multiValueMode.name());
        }
        builder.endObject();
        return builder;
    }

    public ScoreFunctionBuilder setMultiValueMode(MultiValueMode multiValueMode) {
        this.multiValueMode = multiValueMode;
        return this;
    }

    public ScoreFunctionBuilder setMultiValueMode(String multiValueMode) {
        this.multiValueMode = MultiValueMode.fromString(multiValueMode.toUpperCase(Locale.ROOT));
        return this;
    }
}

