/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.percolate;

import org.elasticsearch.action.percolate.MultiPercolateRequest;
import org.elasticsearch.action.percolate.MultiPercolateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class RestMultiPercolateAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    @Inject
    public RestMultiPercolateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mpercolate", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mpercolate", this);
        this.allowExplicitIndex = settings.getAsBoolean("rest.action.multi.allow_explicit_index", (Boolean)true);
    }

    @Override
    public void handleRequest(RestRequest restRequest, RestChannel restChannel, Client client) throws Exception {
        MultiPercolateRequest multiPercolateRequest = new MultiPercolateRequest();
        multiPercolateRequest.indicesOptions(IndicesOptions.fromRequest(restRequest, multiPercolateRequest.indicesOptions()));
        multiPercolateRequest.indices(Strings.splitStringByCommaToArray(restRequest.param("index")));
        multiPercolateRequest.documentType(restRequest.param("type"));
        multiPercolateRequest.add(RestActions.getRestContent(restRequest), restRequest.contentUnsafe(), this.allowExplicitIndex);
        client.multiPercolate(multiPercolateRequest, new RestToXContentListener<MultiPercolateResponse>(restChannel));
    }
}

