/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.index.TransportIndexAction;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.instance.TransportInstanceSingleOperationAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateAction
extends TransportInstanceSingleOperationAction<UpdateRequest, UpdateResponse> {
    private final TransportDeleteAction deleteAction;
    private final TransportIndexAction indexAction;
    private final AutoCreateIndex autoCreateIndex;
    private final TransportCreateIndexAction createIndexAction;
    private final UpdateHelper updateHelper;

    @Inject
    public TransportUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, TransportIndexAction indexAction, TransportDeleteAction deleteAction, TransportCreateIndexAction createIndexAction, UpdateHelper updateHelper) {
        super(settings, "update", threadPool, clusterService, transportService);
        this.indexAction = indexAction;
        this.deleteAction = deleteAction;
        this.createIndexAction = createIndexAction;
        this.updateHelper = updateHelper;
        this.autoCreateIndex = new AutoCreateIndex(settings);
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected UpdateRequest newRequest() {
        return new UpdateRequest();
    }

    @Override
    protected UpdateResponse newResponse() {
        return new UpdateResponse();
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpdateRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpdateRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    @Override
    protected boolean retryOnFailure(Throwable e) {
        return TransportActions.isShardNotAvailableException(e);
    }

    @Override
    protected boolean resolveRequest(ClusterState state, UpdateRequest request, ActionListener<UpdateResponse> listener) {
        MetaData metaData = this.clusterService.state().metaData();
        String aliasOrIndex = request.index();
        request.routing(metaData.resolveIndexRouting(request.routing(), aliasOrIndex));
        request.index(metaData.concreteSingleIndex(request.index()));
        if (request.routing() == null && state.getMetaData().routingRequired(request.index(), request.type())) {
            throw new RoutingMissingException(request.index(), request.type(), request.id());
        }
        return true;
    }

    @Override
    protected void doExecute(final UpdateRequest request, final ActionListener<UpdateResponse> listener) {
        if (this.autoCreateIndex.shouldAutoCreate(request.index(), this.clusterService.state())) {
            request.beforeLocalFork();
            this.createIndexAction.execute(new CreateIndexRequest(request.index()).cause("auto(update api)").masterNodeTimeout(request.timeout()), new ActionListener<CreateIndexResponse>(){

                @Override
                public void onResponse(CreateIndexResponse result) {
                    TransportUpdateAction.this.innerExecute(request, listener);
                }

                @Override
                public void onFailure(Throwable e) {
                    if (ExceptionsHelper.unwrapCause(e) instanceof IndexAlreadyExistsException) {
                        try {
                            TransportUpdateAction.this.innerExecute(request, listener);
                        }
                        catch (Throwable e1) {
                            listener.onFailure(e1);
                        }
                    } else {
                        listener.onFailure(e);
                    }
                }
            });
        } else {
            this.innerExecute(request, listener);
        }
    }

    private void innerExecute(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        super.doExecute(request, listener);
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, UpdateRequest request) throws ElasticsearchException {
        ShardRouting shard;
        if (request.shardId() != -1) {
            return clusterState.routingTable().index(request.index()).shard(request.shardId()).primaryShardIt();
        }
        ShardIterator shardIterator = this.clusterService.operationRouting().indexShards(this.clusterService.state(), request.index(), request.type(), request.id(), request.routing());
        while ((shard = shardIterator.nextOrNull()) != null) {
            if (!shard.primary()) continue;
            return new PlainShardIterator(shardIterator.shardId(), ImmutableList.of(shard));
        }
        return new PlainShardIterator(shardIterator.shardId(), ImmutableList.of());
    }

    @Override
    protected void shardOperation(UpdateRequest request, ActionListener<UpdateResponse> listener) throws ElasticsearchException {
        this.shardOperation(request, listener, 0);
    }

    protected void shardOperation(final UpdateRequest request, final ActionListener<UpdateResponse> listener, final int retryCount) throws ElasticsearchException {
        final UpdateHelper.Result result = this.updateHelper.prepare(request);
        switch (result.operation()) {
            case UPSERT: {
                IndexRequest upsertRequest = (IndexRequest)result.action();
                final BytesReference upsertSourceBytes = upsertRequest.source();
                this.indexAction.execute(upsertRequest, new ActionListener<IndexResponse>(){

                    @Override
                    public void onResponse(IndexResponse response) {
                        UpdateResponse update = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion(), response.isCreated());
                        if (request.fields() != null && request.fields().length > 0) {
                            Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(upsertSourceBytes, true);
                            update.setGetResult(TransportUpdateAction.this.updateHelper.extractGetResult(request, response.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), upsertSourceBytes));
                        } else {
                            update.setGetResult(null);
                        }
                        listener.onResponse(update);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if (((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException || e instanceof DocumentAlreadyExistsException) && retryCount < request.retryOnConflict()) {
                            TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new ActionRunnable<UpdateResponse>(listener){

                                @Override
                                protected void doRun() {
                                    TransportUpdateAction.this.shardOperation(request, this.listener, retryCount + 1);
                                }
                            });
                            return;
                        }
                        listener.onFailure(e);
                    }
                });
                break;
            }
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)result.action();
                final BytesReference indexSourceBytes = indexRequest.source();
                this.indexAction.execute(indexRequest, new ActionListener<IndexResponse>(){

                    @Override
                    public void onResponse(IndexResponse response) {
                        UpdateResponse update = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion(), response.isCreated());
                        update.setGetResult(TransportUpdateAction.this.updateHelper.extractGetResult(request, response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), indexSourceBytes));
                        listener.onResponse(update);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
                            TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new ActionRunnable<UpdateResponse>(listener){

                                @Override
                                protected void doRun() {
                                    TransportUpdateAction.this.shardOperation(request, this.listener, retryCount + 1);
                                }
                            });
                            return;
                        }
                        listener.onFailure(e);
                    }
                });
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)result.action();
                this.deleteAction.execute(deleteRequest, new ActionListener<DeleteResponse>(){

                    @Override
                    public void onResponse(DeleteResponse response) {
                        UpdateResponse update = new UpdateResponse(response.getIndex(), response.getType(), response.getId(), response.getVersion(), false);
                        update.setGetResult(TransportUpdateAction.this.updateHelper.extractGetResult(request, response.getVersion(), result.updatedSourceAsMap(), result.updateSourceContentType(), null));
                        listener.onResponse(update);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        if ((e = ExceptionsHelper.unwrapCause(e)) instanceof VersionConflictEngineException && retryCount < request.retryOnConflict()) {
                            TransportUpdateAction.this.threadPool.executor(TransportUpdateAction.this.executor()).execute(new ActionRunnable<UpdateResponse>(listener){

                                @Override
                                protected void doRun() {
                                    TransportUpdateAction.this.shardOperation(request, this.listener, retryCount + 1);
                                }
                            });
                            return;
                        }
                        listener.onFailure(e);
                    }
                });
                break;
            }
            case NONE: {
                UpdateResponse update = (UpdateResponse)result.action();
                listener.onResponse(update);
                break;
            }
            default: {
                throw new ElasticsearchIllegalStateException("Illegal operation " + (Object)((Object)result.operation()));
            }
        }
    }
}

