/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class GlobalOrdinalsSignificantTermsAggregator
extends GlobalOrdinalsStringTermsAggregator {
    protected long numCollectedDocs;
    protected final SignificantTermsAggregatorFactory termsAggFactory;

    public GlobalOrdinalsSignificantTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory) {
        super(name, factories, valuesSource, estimatedBucketCount, maxOrd, null, bucketCountThresholds, includeExclude, aggregationContext, parent, Aggregator.SubAggCollectionMode.DEPTH_FIRST);
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        super.collect(doc, owningBucketOrdinal);
        ++this.numCollectedDocs;
    }

    @Override
    public SignificantStringTerms buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        if (this.globalValues == null) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.globalValues.getMaxOrd(), (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.prepareBackground(this.context);
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantStringTerms.Bucket spare = null;
        for (long globalTermOrd = 0L; globalTermOrd < this.globalValues.getMaxOrd(); ++globalTermOrd) {
            int bucketDocCount;
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalTermOrd)) continue;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            int n = bucketDocCount = bucketOrd < 0L ? 0 : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0) continue;
            if (spare == null) {
                spare = new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null);
            }
            spare.bucketOrd = bucketOrd;
            GlobalOrdinalsSignificantTermsAggregator.copy(this.globalValues.getValueByOrd(globalTermOrd), spare.termBytes);
            spare.subsetDf = bucketDocCount;
            spare.subsetSize = subsetSize;
            spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.termBytes);
            spare.supersetSize = supersetSize;
            spare.updateScore(this.termsAggFactory.getSignificanceHeuristic());
            if (spare.subsetDf < this.bucketCountThresholds.getShardMinDocCount()) continue;
            spare = (SignificantStringTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        InternalSignificantTerms.Bucket[] list = new InternalSignificantTerms.Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            SignificantStringTerms.Bucket bucket = (SignificantStringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i] = bucket;
        }
        return new SignificantStringTerms(subsetSize, supersetSize, this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Arrays.asList(list));
    }

    @Override
    public SignificantStringTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searchContext().searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantStringTerms(0L, supersetSize, this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.termsAggFactory.getSignificanceHeuristic(), Collections.emptyList());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.termsAggFactory);
    }

    public static class WithHash
    extends GlobalOrdinalsSignificantTermsAggregator {
        private final LongHash bucketOrds;

        public WithHash(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggFactory) {
            super(name, factories, valuesSource, estimatedBucketCount, estimatedBucketCount, bucketCountThresholds, includeExclude, aggregationContext, parent, termsAggFactory);
            this.bucketOrds = new LongHash(estimatedBucketCount, aggregationContext.bigArrays());
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
            ++this.numCollectedDocs;
            int numOrds = this.globalValues.setDocument(doc);
            for (int i = 0; i < numOrds; ++i) {
                long globalOrd = this.globalValues.nextOrd();
                long bucketOrd = this.bucketOrds.add(globalOrd);
                if (bucketOrd < 0L) {
                    bucketOrd = -1L - bucketOrd;
                    this.collectExistingBucket(doc, bucketOrd);
                    continue;
                }
                this.collectBucket(doc, bucketOrd);
            }
        }

        @Override
        protected long getBucketOrd(long termOrd) {
            return this.bucketOrds.find(termOrd);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.termsAggFactory, this.bucketOrds);
        }
    }
}

