/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageXmlizer;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.XmlizePageCondition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.w3c.dom.Document;
import util.XmlWriter;

public class SerializedPageResponder
implements SecureResponder {
    private XmlizePageCondition xmlizePageCondition = new XmlizePageCondition(){

        @Override
        public boolean canBeXmlized(WikiPage page) {
            return !(page instanceof SymbolicPage);
        }
    };

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws IOException {
        WikiPage page = this.getRequestedPage(request, context);
        if (page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        if ("pages".equals(request.getInput("type"))) {
            PageXmlizer pageXmlizer = new PageXmlizer();
            pageXmlizer.addPageCondition(this.xmlizePageCondition);
            Document doc = pageXmlizer.xmlize(page);
            SimpleResponse response = this.makeResponseWithxml(doc);
            return response;
        }
        if ("data".equals(request.getInput("type"))) {
            Document doc = new PageXmlizer().xmlize(page.getData());
            SimpleResponse response = this.makeResponseWithxml(doc);
            return response;
        }
        Object object = this.getObjectToSerialize(request, page);
        byte[] bytes = this.serializeToBytes(object);
        return this.responseWith(bytes);
    }

    private SimpleResponse makeResponseWithxml(Document doc) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(output);
        xmlWriter.write(doc);
        xmlWriter.flush();
        xmlWriter.close();
        SimpleResponse response = new SimpleResponse();
        response.setContentType("text/xml");
        response.setContent(output.toByteArray());
        return response;
    }

    private Object getObjectToSerialize(Request request, WikiPage page) {
        Object object;
        if ("versions".equals(request.getInput("type"))) {
            object = page.getVersions();
        } else if ("meat".equals(request.getInput("type"))) {
            WikiPage originalPage = page;
            if (request.hasInput("version")) {
                originalPage = page.getVersion((String)request.getInput("version"));
            }
            object = originalPage.getData();
        } else {
            throw new RuntimeException("Improper use of proxy retrieval");
        }
        return object;
    }

    private WikiPage getRequestedPage(Request request, FitNesseContext context) {
        String resource = request.getResource();
        WikiPagePath path = PathParser.parse(resource);
        WikiPage page = context.root.getPageCrawler().getPage(path);
        return page;
    }

    private SimpleResponse responseWith(byte[] bytes) {
        SimpleResponse response = new SimpleResponse();
        response.setContentType("application/octet-stream");
        response.setContent(bytes);
        return response;
    }

    private byte[] serializeToBytes(Object object) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(byteStream);
        os.writeObject(object);
        os.close();
        byte[] bytes = byteStream.toByteArray();
        return bytes;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

