/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshFile;
import com.xebialabs.overthere.ssh.SshSftpConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.FilePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSftpFile
extends SshFile<SshSftpConnection> {
    private static Logger logger = LoggerFactory.getLogger(SshSftpFile.class);

    public SshSftpFile(SshSftpConnection connection, String path) {
        super(connection, path);
    }

    protected String getSftpPath() {
        return ((SshSftpConnection)this.connection).pathToSftpPath(this.getPath());
    }

    @Override
    public boolean exists() {
        logger.debug("Checking {} for existence", (Object)this);
        try {
            return ((SshSftpConnection)this.connection).getSharedSftpClient().statExistence(this.getSftpPath()) != null;
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot check existence of file %s", this), e);
        }
    }

    @Override
    public boolean isFile() {
        return this.stat().getType() == FileMode.Type.REGULAR;
    }

    @Override
    public boolean isDirectory() {
        return this.stat().getType() == FileMode.Type.DIRECTORY;
    }

    @Override
    public long lastModified() {
        return this.stat().getMtime() * 1000L;
    }

    @Override
    public long length() {
        return this.stat().getSize();
    }

    @Override
    public boolean canRead() {
        return this.hasPermission(FilePermission.USR_R);
    }

    @Override
    public boolean canWrite() {
        return this.hasPermission(FilePermission.USR_W);
    }

    @Override
    public boolean canExecute() {
        return this.hasPermission(FilePermission.USR_X);
    }

    private boolean hasPermission(FilePermission perm) {
        return this.stat().getPermissions().contains(perm);
    }

    protected FileAttributes stat() {
        logger.debug("Statting {}", (Object)this);
        try {
            return ((SshSftpConnection)this.connection).getSharedSftpClient().stat(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot stat %s", this), e);
        }
    }

    @Override
    public List<OverthereFile> listFiles() {
        logger.debug("Listing directory {}", (Object)this);
        try {
            List ls = ((SshSftpConnection)this.connection).getSharedSftpClient().ls(this.getSftpPath());
            ArrayList files = Lists.newArrayList();
            for (RemoteResourceInfo l : ls) {
                String filename = l.getName();
                if (filename.equals(".") || filename.equals("..")) continue;
                files.add(this.getFile(filename));
            }
            return files;
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot list directory %s", this), e);
        }
    }

    @Override
    public void mkdir() {
        logger.debug("Creating directory {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().mkdir(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot create directory %s", this), e);
        }
    }

    @Override
    public void mkdirs() {
        logger.debug("Creating directories {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().mkdirs(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot create directories %s", this), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void renameTo(OverthereFile dest) {
        logger.debug("Renaming {} to {}", (Object)this, (Object)dest);
        if (!(dest instanceof SshSftpFile)) throw new RuntimeIOException(String.format("Cannot move/rename ssh:%s: file/directory %s  to non-ssh:%s: file/directory %s", ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase(), this, ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase(), dest));
        SshSftpFile sftpDest = (SshSftpFile)dest;
        if (sftpDest.getConnection() != this.getConnection()) throw new RuntimeIOException(String.format("Cannot move/rename ssh:%s: file/directory %s to file/directory %s because it is in a different connection", ((SshSftpConnection)this.connection).sshConnectionType.toString().toLowerCase(), this, dest));
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rename(this.getSftpPath(), sftpDest.getSftpPath());
            return;
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot move/rename file/directory %s to %s", this, dest), e);
        }
    }

    @Override
    public void setExecutable(boolean executable) {
        logger.debug("Setting execute permission on {} to {}", (Object)this, (Object)executable);
        try {
            int permissionsMask = ((SshSftpConnection)this.connection).getSharedSftpClient().stat(this.getSftpPath()).getMode().getPermissionsMask();
            permissionsMask = executable ? (permissionsMask |= 0x49) : (permissionsMask &= 0xFFFFFFB6);
            ((SshSftpConnection)this.connection).getSharedSftpClient().chmod(this.getPath(), permissionsMask);
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot set execute permission on %s to %b", this, executable), e);
        }
    }

    @Override
    protected void deleteFile() {
        logger.debug("Deleting file {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rm(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot delete file %s", this), e);
        }
    }

    @Override
    protected void deleteDirectory() {
        logger.debug("Deleting directory {}", (Object)this);
        try {
            ((SshSftpConnection)this.connection).getSharedSftpClient().rmdir(this.getSftpPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot delete directory %s", this), e);
        }
    }

    @Override
    public InputStream getInputStream() {
        logger.debug("Opening SFTP input stream for {}", (Object)this);
        try {
            SFTPClient sftp = ((SshSftpConnection)this.connection).connectSftp();
            RemoteFile remoteFile = sftp.open(this.getSftpPath(), (Set)Sets.newHashSet((Object[])new OpenMode[]{OpenMode.READ}));
            RemoteFile.RemoteFileInputStream wrapped = new RemoteFile.RemoteFileInputStream(remoteFile);
            return this.asBuffered(new InputStream((InputStream)wrapped, remoteFile, sftp){
                final /* synthetic */ InputStream val$wrapped;
                final /* synthetic */ RemoteFile val$remoteFile;
                final /* synthetic */ SFTPClient val$sftp;
                {
                    this.val$wrapped = inputStream;
                    this.val$remoteFile = remoteFile;
                    this.val$sftp = sFTPClient;
                }

                @Override
                public int read() throws IOException {
                    return this.val$wrapped.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return this.val$wrapped.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return this.val$wrapped.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    return this.val$wrapped.skip(n);
                }

                @Override
                public int available() throws IOException {
                    return this.val$wrapped.available();
                }

                @Override
                public boolean markSupported() {
                    return this.val$wrapped.markSupported();
                }

                @Override
                public void mark(int readlimit) {
                    this.val$wrapped.mark(readlimit);
                }

                @Override
                public void reset() throws IOException {
                    this.val$wrapped.reset();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    logger.info("Closing SFTP input stream for {}", (Object)SshSftpFile.this);
                    try {
                        this.val$wrapped.close();
                    }
                    finally {
                        OverthereUtils.closeQuietly((Closeable)this.val$remoteFile);
                        ((SshSftpConnection)SshSftpFile.this.connection).disconnectSftp(this.val$sftp);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot read from file " + this, e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        logger.debug("Opening SFTP ouput stream for {}", (Object)this);
        try {
            SFTPClient sftp = ((SshSftpConnection)this.connection).connectSftp();
            RemoteFile remoteFile = sftp.open(this.getSftpPath(), (Set)Sets.newHashSet((Object[])new OpenMode[]{OpenMode.CREAT, OpenMode.WRITE, OpenMode.TRUNC}));
            RemoteFile.RemoteFileOutputStream wrapped = new RemoteFile.RemoteFileOutputStream(remoteFile);
            return this.asBuffered(new OutputStream((OutputStream)wrapped, remoteFile, sftp){
                final /* synthetic */ OutputStream val$wrapped;
                final /* synthetic */ RemoteFile val$remoteFile;
                final /* synthetic */ SFTPClient val$sftp;
                {
                    this.val$wrapped = outputStream;
                    this.val$remoteFile = remoteFile;
                    this.val$sftp = sFTPClient;
                }

                @Override
                public void write(int b) throws IOException {
                    this.val$wrapped.write(b);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.val$wrapped.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    this.val$wrapped.write(b, off, len);
                }

                @Override
                public void flush() throws IOException {
                    this.val$wrapped.flush();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    logger.info("Closing SFTP output stream for {}", (Object)SshSftpFile.this);
                    try {
                        this.val$wrapped.close();
                    }
                    finally {
                        OverthereUtils.closeQuietly((Closeable)this.val$remoteFile);
                        ((SshSftpConnection)SshSftpFile.this.connection).disconnectSftp(this.val$sftp);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Cannot write to %s", this), e);
        }
    }
}

