/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.template.HtmlPage;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;

public class ErrorResponder
implements Responder {
    Exception exception;
    private String message;

    public ErrorResponder(Exception e) {
        this.exception = e;
    }

    public ErrorResponder(String message) {
        this.message = message;
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        SimpleResponse response = new SimpleResponse(400);
        HtmlPage html = context.pageFactory.newPage();
        html.addTitles("Error Occured");
        html.setMainTemplate("error");
        html.put("exception", this.exception);
        if (this.exception != null) {
            html.put("exception", this.exception);
        }
        if (this.message != null) {
            html.put("message", this.message);
        }
        response.setContent(html.html());
        return response;
    }

    public static String makeExceptionString(Throwable e) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(e.toString()).append("\n");
        StackTraceElement[] stackTreace = e.getStackTrace();
        for (int i = 0; i < stackTreace.length; ++i) {
            buffer.append("\t" + stackTreace[i]).append("\n");
        }
        return buffer.toString();
    }
}

