/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.directory.DirContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.SingleContextSource;
import org.springframework.ldap.transaction.compensating.BindOperationRecorder;
import org.springframework.ldap.transaction.compensating.ModifyAttributesOperationRecorder;
import org.springframework.ldap.transaction.compensating.NullOperationRecorder;
import org.springframework.ldap.transaction.compensating.RebindOperationRecorder;
import org.springframework.ldap.transaction.compensating.RenameOperationRecorder;
import org.springframework.ldap.transaction.compensating.TempEntryRenamingStrategy;
import org.springframework.ldap.transaction.compensating.UnbindOperationRecorder;
import org.springframework.transaction.compensating.CompensatingTransactionOperationFactory;
import org.springframework.transaction.compensating.CompensatingTransactionOperationRecorder;

public class LdapCompensatingTransactionOperationFactory
implements CompensatingTransactionOperationFactory {
    private static Log log = LogFactory.getLog((Class)LdapCompensatingTransactionOperationFactory.class);
    private TempEntryRenamingStrategy renamingStrategy;

    public LdapCompensatingTransactionOperationFactory(TempEntryRenamingStrategy renamingStrategy) {
        this.renamingStrategy = renamingStrategy;
    }

    public CompensatingTransactionOperationRecorder createRecordingOperation(Object resource, String operation) {
        if (StringUtils.equals((String)operation, (String)"bind")) {
            log.debug((Object)"Bind operation recorded");
            return new BindOperationRecorder(this.createLdapOperationsInstance((DirContext)resource));
        }
        if (StringUtils.equals((String)operation, (String)"rebind")) {
            log.debug((Object)"Rebind operation recorded");
            return new RebindOperationRecorder(this.createLdapOperationsInstance((DirContext)resource), this.renamingStrategy);
        }
        if (StringUtils.equals((String)operation, (String)"rename")) {
            log.debug((Object)"Rename operation recorded");
            return new RenameOperationRecorder(this.createLdapOperationsInstance((DirContext)resource));
        }
        if (StringUtils.equals((String)operation, (String)"modifyAttributes")) {
            return new ModifyAttributesOperationRecorder(this.createLdapOperationsInstance((DirContext)resource));
        }
        if (StringUtils.equals((String)operation, (String)"unbind")) {
            return new UnbindOperationRecorder(this.createLdapOperationsInstance((DirContext)resource), this.renamingStrategy);
        }
        log.warn((Object)("No suitable CompensatingTransactionOperationRecorder found for method " + operation + ". Operation will not be transacted."));
        return new NullOperationRecorder();
    }

    LdapOperations createLdapOperationsInstance(DirContext ctx) {
        return new LdapTemplate(new SingleContextSource(ctx));
    }
}

