/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeReadOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetIndexTemplatesAction
extends TransportMasterNodeReadOperationAction<GetIndexTemplatesRequest, GetIndexTemplatesResponse> {
    @Inject
    public TransportGetIndexTemplatesAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, "indices/template/get", transportService, clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected GetIndexTemplatesRequest newRequest() {
        return new GetIndexTemplatesRequest();
    }

    @Override
    protected GetIndexTemplatesResponse newResponse() {
        return new GetIndexTemplatesResponse();
    }

    @Override
    protected void masterOperation(GetIndexTemplatesRequest request, ClusterState state, ActionListener<GetIndexTemplatesResponse> listener) throws ElasticsearchException {
        ArrayList<IndexTemplateMetaData> results = request.names().length == 0 ? Lists.newArrayList(state.metaData().templates().values().toArray(IndexTemplateMetaData.class)) : Lists.newArrayList();
        for (String name : request.names()) {
            if (Regex.isSimpleMatchPattern(name)) {
                for (ObjectObjectCursor<String, IndexTemplateMetaData> objectObjectCursor : state.metaData().templates()) {
                    if (!Regex.simpleMatch(name, (String)objectObjectCursor.key)) continue;
                    results.add((IndexTemplateMetaData)objectObjectCursor.value);
                }
                continue;
            }
            if (!state.metaData().templates().containsKey(name)) continue;
            results.add(state.metaData().templates().get(name));
        }
        listener.onResponse(new GetIndexTemplatesResponse((List<IndexTemplateMetaData>)results));
    }
}

