/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.delete;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptRequest;
import org.elasticsearch.action.indexedscripts.delete.DeleteIndexedScriptResponse;
import org.elasticsearch.action.support.DelegatingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexedScriptAction
extends HandledTransportAction<DeleteIndexedScriptRequest, DeleteIndexedScriptResponse> {
    private ScriptService scriptService;
    private Client client;

    @Inject
    public TransportDeleteIndexedScriptAction(Settings settings, ThreadPool threadPool, ScriptService scriptService, Client client, TransportService transportService) {
        super(settings, "deleteIndexedScript", threadPool, transportService);
        this.scriptService = scriptService;
        this.client = client;
    }

    @Override
    public DeleteIndexedScriptRequest newRequestInstance() {
        return new DeleteIndexedScriptRequest();
    }

    @Override
    protected void doExecute(DeleteIndexedScriptRequest request, ActionListener<DeleteIndexedScriptResponse> listener) {
        this.scriptService.deleteScriptFromIndex(this.client, request.scriptLang(), request.id(), request.version(), (ActionListener<DeleteResponse>)new DelegatingActionListener<DeleteResponse, DeleteIndexedScriptResponse>(listener){

            @Override
            public DeleteIndexedScriptResponse getDelegatedFromInstigator(DeleteResponse deleteResponse) {
                return new DeleteIndexedScriptResponse(deleteResponse.getIndex(), deleteResponse.getType(), deleteResponse.getType(), deleteResponse.getVersion(), deleteResponse.isFound());
            }
        });
    }
}

