/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class BenchmarkMetaData
implements MetaData.Custom {
    public static final String TYPE = "benchmark";
    public static final Factory FACTORY = new Factory();
    private final ImmutableList<Entry> entries;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BenchmarkMetaData that = (BenchmarkMetaData)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public BenchmarkMetaData(ImmutableList<Entry> entries) {
        this.entries = entries;
    }

    public BenchmarkMetaData(Entry ... entries) {
        this.entries = ImmutableList.copyOf(entries);
    }

    public ImmutableList<Entry> entries() {
        return this.entries;
    }

    public boolean contains(String benchmarkId) {
        for (Entry e : this.entries) {
            if (!e.benchmarkId.equals(benchmarkId)) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    implements MetaData.Custom.Factory<BenchmarkMetaData> {
        @Override
        public String type() {
            return BenchmarkMetaData.TYPE;
        }

        @Override
        public BenchmarkMetaData readFrom(StreamInput in) throws IOException {
            Entry[] entries = new Entry[in.readVInt()];
            for (int i = 0; i < entries.length; ++i) {
                String benchmarkId = in.readString();
                State state = State.fromId(in.readByte());
                String[] nodes = in.readStringArray();
                entries[i] = new Entry(benchmarkId, state, nodes);
            }
            return new BenchmarkMetaData(entries);
        }

        @Override
        public void writeTo(BenchmarkMetaData repositories, StreamOutput out) throws IOException {
            out.writeVInt(repositories.entries().size());
            for (Entry entry : repositories.entries()) {
                out.writeString(entry.benchmarkId());
                out.writeByte(entry.state().id());
                out.writeStringArray(entry.nodes());
            }
        }

        @Override
        public BenchmarkMetaData fromXContent(XContentParser parser) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toXContent(BenchmarkMetaData customIndexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray("benchmarks");
            for (Entry entry : customIndexMetaData.entries()) {
                this.toXContent(entry, builder, params);
            }
            builder.endArray();
        }

        @Override
        public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("id", entry.benchmarkId());
            builder.field("state", (Object)entry.state());
            builder.startArray("on_nodes");
            for (String nodeid : entry.nodes()) {
                builder.value(nodeid);
            }
            builder.endArray();
            builder.endObject();
        }

        @Override
        public boolean isPersistent() {
            return false;
        }
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State STARTED = new State(0);
        public static final /* enum */ State SUCCESS = new State(1);
        public static final /* enum */ State FAILED = new State(2);
        public static final /* enum */ State ABORTED = new State(3);
        private static final State[] STATES;
        private final byte id;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public boolean completed() {
            return this == SUCCESS || this == FAILED;
        }

        public static State fromId(byte id) {
            if (id < 0 || id >= State.values().length) {
                throw new ElasticsearchIllegalArgumentException("No benchmark state for value [" + id + "]");
            }
            return STATES[id];
        }

        static {
            $VALUES = new State[]{STARTED, SUCCESS, FAILED, ABORTED};
            STATES = new State[State.values().length];
            for (State state : State.values()) {
                assert (state.id() < STATES.length && state.id() >= 0);
                State.STATES[state.id()] = state;
            }
        }
    }

    public static class Entry {
        private final State state;
        private final String benchmarkId;
        private final String[] nodeids;

        public Entry(Entry e, State state) {
            this(e.benchmarkId(), state, e.nodes());
        }

        public Entry(String benchmarkId, State state, String[] nodeIds) {
            this.state = state;
            this.benchmarkId = benchmarkId;
            this.nodeids = nodeIds;
        }

        public String benchmarkId() {
            return this.benchmarkId;
        }

        public State state() {
            return this.state;
        }

        public String[] nodes() {
            return this.nodeids;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.benchmarkId.equals(entry.benchmarkId)) {
                return false;
            }
            return this.state == entry.state;
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.benchmarkId.hashCode();
            return result;
        }
    }
}

