/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.index.shard.ShardId;

public class RoutingNodes
implements Iterable<RoutingNode> {
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final RoutingTable routingTable;
    private final Map<String, RoutingNode> nodesToShards = Maps.newHashMap();
    private final UnassignedShards unassignedShards = new UnassignedShards();
    private final List<MutableShardRouting> ignoredUnassignedShards = Lists.newArrayList();
    private final Map<ShardId, List<MutableShardRouting>> assignedShards = Maps.newHashMap();
    private int inactivePrimaryCount = 0;
    private int inactiveShardCount = 0;
    private int relocatingShards = 0;
    private Set<ShardId> clearPostAllocationFlag;
    private final Map<String, ObjectIntOpenHashMap<String>> nodesPerAttributeNames = new HashMap<String, ObjectIntOpenHashMap<String>>();
    private static final List<MutableShardRouting> EMPTY = Collections.emptyList();

    public RoutingNodes(ClusterState clusterState) {
        this.metaData = clusterState.metaData();
        this.blocks = clusterState.blocks();
        this.routingTable = clusterState.routingTable();
        HashMap nodesToShards = Maps.newHashMap();
        for (ObjectCursor<DiscoveryNode> objectCursor : clusterState.nodes().dataNodes().values()) {
            nodesToShards.put(((DiscoveryNode)objectCursor.value).id(), new ArrayList());
        }
        for (IndexRoutingTable indexRoutingTable : this.routingTable.indicesRouting().values()) {
            for (IndexShardRoutingTable indexShard : indexRoutingTable) {
                for (ShardRouting shard : indexShard) {
                    if (shard.assignedToNode()) {
                        List<MutableShardRouting> entries = (ArrayList<MutableShardRouting>)nodesToShards.get(shard.currentNodeId());
                        if (entries == null) {
                            entries = Lists.newArrayList();
                            nodesToShards.put(shard.currentNodeId(), entries);
                        }
                        MutableShardRouting sr = new MutableShardRouting(shard);
                        entries.add(sr);
                        this.assignedShardsAdd(sr);
                        if (shard.relocating()) {
                            entries = (List)nodesToShards.get(shard.relocatingNodeId());
                            ++this.relocatingShards;
                            if (entries == null) {
                                entries = Lists.newArrayList();
                                nodesToShards.put(shard.relocatingNodeId(), entries);
                            }
                            sr = new MutableShardRouting(shard.index(), shard.id(), shard.relocatingNodeId(), shard.currentNodeId(), shard.primary(), ShardRoutingState.INITIALIZING, shard.version());
                            entries.add(sr);
                            this.assignedShardsAdd(sr);
                            continue;
                        }
                        if (shard.active()) continue;
                        if (shard.primary()) {
                            ++this.inactivePrimaryCount;
                        }
                        ++this.inactiveShardCount;
                        continue;
                    }
                    MutableShardRouting sr = new MutableShardRouting(shard);
                    this.assignedShardsAdd(sr);
                    this.unassignedShards.add(sr);
                }
            }
        }
        for (Map.Entry entry : nodesToShards.entrySet()) {
            String nodeId = (String)entry.getKey();
            this.nodesToShards.put(nodeId, new RoutingNode(nodeId, clusterState.nodes().get(nodeId), (List)entry.getValue()));
        }
    }

    @Override
    public Iterator<RoutingNode> iterator() {
        return Iterators.unmodifiableIterator(this.nodesToShards.values().iterator());
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public int requiredAverageNumberOfShardsPerNode() {
        int totalNumberOfShards = 0;
        for (ObjectCursor<IndexMetaData> objectCursor : this.metaData.indices().values()) {
            IndexMetaData indexMetaData = (IndexMetaData)objectCursor.value;
            if (indexMetaData.state() != IndexMetaData.State.OPEN) continue;
            totalNumberOfShards += indexMetaData.totalNumberOfShards();
        }
        return totalNumberOfShards / this.nodesToShards.size();
    }

    public boolean hasUnassigned() {
        return !this.unassignedShards.isEmpty();
    }

    public List<MutableShardRouting> ignoredUnassigned() {
        return this.ignoredUnassignedShards;
    }

    public UnassignedShards unassigned() {
        return this.unassignedShards;
    }

    public RoutingNodesIterator nodes() {
        return new RoutingNodesIterator(this.nodesToShards.values().iterator());
    }

    public void addClearPostAllocationFlag(ShardId shardId) {
        if (this.clearPostAllocationFlag == null) {
            this.clearPostAllocationFlag = Sets.newHashSet();
        }
        this.clearPostAllocationFlag.add(shardId);
    }

    public Iterable<ShardId> getShardsToClearPostAllocationFlag() {
        if (this.clearPostAllocationFlag == null) {
            return ImmutableSet.of();
        }
        return this.clearPostAllocationFlag;
    }

    public RoutingNode node(String nodeId) {
        return this.nodesToShards.get(nodeId);
    }

    public ObjectIntOpenHashMap<String> nodesPerAttributesCounts(String attributeName) {
        ObjectIntOpenHashMap<String> nodesPerAttributesCounts = this.nodesPerAttributeNames.get(attributeName);
        if (nodesPerAttributesCounts != null) {
            return nodesPerAttributesCounts;
        }
        nodesPerAttributesCounts = new ObjectIntOpenHashMap();
        for (RoutingNode routingNode : this) {
            String attrValue = routingNode.node().attributes().get(attributeName);
            nodesPerAttributesCounts.addTo(attrValue, 1);
        }
        this.nodesPerAttributeNames.put(attributeName, nodesPerAttributesCounts);
        return nodesPerAttributesCounts;
    }

    public boolean hasUnassignedPrimaries() {
        return this.unassignedShards.numPrimaries() > 0;
    }

    public boolean hasUnassignedShards() {
        return !this.unassignedShards.isEmpty();
    }

    public boolean hasInactivePrimaries() {
        return this.inactivePrimaryCount > 0;
    }

    public boolean hasInactiveShards() {
        return this.inactiveShardCount > 0;
    }

    public int getRelocatingShardCount() {
        return this.relocatingShards;
    }

    public MutableShardRouting activePrimary(ShardRouting shard) {
        for (MutableShardRouting shardRouting : this.assignedShards(shard.shardId())) {
            if (!shardRouting.primary() || !shardRouting.active()) continue;
            return shardRouting;
        }
        return null;
    }

    public MutableShardRouting activeReplica(ShardRouting shard) {
        for (MutableShardRouting shardRouting : this.assignedShards(shard.shardId())) {
            if (shardRouting.primary() || !shardRouting.active()) continue;
            return shardRouting;
        }
        return null;
    }

    public Iterable<MutableShardRouting> assignedShards(ShardRouting shard) {
        return this.assignedShards(shard.shardId());
    }

    public boolean allReplicasActive(ShardRouting shardRouting) {
        List<MutableShardRouting> shards = this.assignedShards(shardRouting.shardId());
        if (shards.isEmpty() || shards.size() < this.routingTable.index(shardRouting.index()).shard(shardRouting.id()).size()) {
            return false;
        }
        for (MutableShardRouting shard : shards) {
            if (shard.active()) continue;
            return false;
        }
        return true;
    }

    public List<MutableShardRouting> shards(Predicate<MutableShardRouting> predicate) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            for (MutableShardRouting shardRouting : routingNode) {
                if (!predicate.apply(shardRouting)) continue;
                shards.add(shardRouting);
            }
        }
        return shards;
    }

    public List<MutableShardRouting> shardsWithState(ShardRoutingState ... state) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(state));
        }
        for (ShardRoutingState s : state) {
            if (s != ShardRoutingState.UNASSIGNED) continue;
            Iterables.addAll(shards, this.unassigned());
            break;
        }
        return shards;
    }

    public List<MutableShardRouting> shardsWithState(String index, ShardRoutingState ... state) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (RoutingNode routingNode : this) {
            shards.addAll(routingNode.shardsWithState(index, state));
        }
        for (ShardRoutingState s : state) {
            if (s != ShardRoutingState.UNASSIGNED) continue;
            for (MutableShardRouting unassignedShard : this.unassignedShards) {
                if (!unassignedShard.index().equals(index)) continue;
                shards.add(unassignedShard);
            }
            break;
        }
        return shards;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder("routing_nodes:\n");
        for (RoutingNode routingNode : this) {
            sb.append(routingNode.prettyPrint());
        }
        sb.append("---- unassigned\n");
        for (MutableShardRouting shardEntry : this.unassignedShards) {
            sb.append("--------").append(shardEntry.shortSummary()).append('\n');
        }
        return sb.toString();
    }

    public void assign(MutableShardRouting shard, String nodeId) {
        ShardRoutingState oldState = shard.state();
        shard.assignToNode(nodeId);
        this.node(nodeId).add(shard);
        if (oldState == ShardRoutingState.UNASSIGNED) {
            ++this.inactiveShardCount;
            if (shard.primary()) {
                ++this.inactivePrimaryCount;
            }
        }
        if (shard.state() == ShardRoutingState.RELOCATING) {
            ++this.relocatingShards;
        }
        this.assignedShardsAdd(shard);
    }

    public void relocate(MutableShardRouting shard, String nodeId) {
        ++this.relocatingShards;
        shard.relocate(nodeId);
    }

    public void started(MutableShardRouting shard) {
        if (!shard.active() && shard.relocatingNodeId() == null) {
            --this.inactiveShardCount;
            if (shard.primary()) {
                --this.inactivePrimaryCount;
            }
        } else if (shard.relocating()) {
            --this.relocatingShards;
        }
        assert (!shard.started());
        shard.moveToStarted();
    }

    public void cancelRelocation(MutableShardRouting shard) {
        --this.relocatingShards;
        shard.cancelRelocation();
    }

    public void swapPrimaryFlag(MutableShardRouting ... shards) {
        for (MutableShardRouting shard : shards) {
            if (shard.primary()) {
                shard.moveFromPrimary();
                if (!shard.unassigned()) continue;
                this.unassignedShards.primaries--;
                continue;
            }
            shard.moveToPrimary();
            if (!shard.unassigned()) continue;
            this.unassignedShards.primaries++;
        }
    }

    private List<MutableShardRouting> assignedShards(ShardId shardId) {
        List<MutableShardRouting> replicaSet = this.assignedShards.get(shardId);
        return replicaSet == null ? EMPTY : Collections.unmodifiableList(replicaSet);
    }

    private void remove(MutableShardRouting shard) {
        if (!shard.active() && shard.relocatingNodeId() == null) {
            --this.inactiveShardCount;
            assert (this.inactiveShardCount >= 0);
            if (shard.primary()) {
                --this.inactivePrimaryCount;
            }
        } else if (shard.relocating()) {
            this.cancelRelocation(shard);
        }
        this.assignedShardsRemove(shard);
    }

    private void assignedShardsAdd(MutableShardRouting shard) {
        if (shard.unassigned()) {
            return;
        }
        List<MutableShardRouting> shards = this.assignedShards.get(shard.shardId());
        if (shards == null) {
            shards = Lists.newArrayList();
            this.assignedShards.put(shard.shardId(), shards);
        }
        assert (this.assertInstanceNotInList(shard, shards));
        shards.add(shard);
    }

    private boolean assertInstanceNotInList(MutableShardRouting shard, List<MutableShardRouting> shards) {
        for (MutableShardRouting s : shards) {
            assert (s != shard);
        }
        return true;
    }

    private void assignedShardsRemove(MutableShardRouting shard) {
        List<MutableShardRouting> replicaSet = this.assignedShards.get(shard.shardId());
        if (replicaSet != null) {
            Iterator<MutableShardRouting> iterator = replicaSet.iterator();
            while (iterator.hasNext()) {
                if (shard != iterator.next()) continue;
                iterator.remove();
                return;
            }
            assert (false) : "Illegal state";
        }
    }

    public boolean isKnown(DiscoveryNode node) {
        return this.nodesToShards.containsKey(node.getId());
    }

    public void addNode(DiscoveryNode node) {
        RoutingNode routingNode = new RoutingNode(node.id(), node);
        this.nodesToShards.put(routingNode.nodeId(), routingNode);
    }

    public RoutingNodeIterator routingNodeIter(String nodeId) {
        RoutingNode routingNode = this.nodesToShards.get(nodeId);
        if (routingNode == null) {
            return null;
        }
        assert (RoutingNodes.assertShardStats(this));
        return new RoutingNodeIterator(routingNode);
    }

    public RoutingNode[] toArray() {
        return this.nodesToShards.values().toArray(new RoutingNode[this.nodesToShards.size()]);
    }

    public static boolean assertShardStats(RoutingNodes routingNodes) {
        boolean run = false;
        if (!$assertionsDisabled) {
            run = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!run) {
            return true;
        }
        int unassignedPrimaryCount = 0;
        int inactivePrimaryCount = 0;
        int inactiveShardCount = 0;
        int relocating = 0;
        HashSet<ShardId> seenShards = Sets.newHashSet();
        HashMap<String, Integer> indicesAndShards = new HashMap<String, Integer>();
        for (RoutingNode node : routingNodes) {
            for (MutableShardRouting mutableShardRouting : node) {
                if (!mutableShardRouting.active() && mutableShardRouting.relocatingNodeId() == null && !mutableShardRouting.relocating()) {
                    ++inactiveShardCount;
                    if (mutableShardRouting.primary()) {
                        ++inactivePrimaryCount;
                    }
                }
                if (mutableShardRouting.relocating()) {
                    ++relocating;
                }
                seenShards.add(mutableShardRouting.shardId());
                Integer i = (Integer)indicesAndShards.get(mutableShardRouting.index());
                if (i == null) {
                    i = mutableShardRouting.id();
                }
                indicesAndShards.put(mutableShardRouting.index(), Math.max(i, mutableShardRouting.id()));
            }
        }
        Set entries = indicesAndShards.entrySet();
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (Map.Entry entry : entries) {
            String index = (String)entry.getKey();
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                for (RoutingNode routingNode : routingNodes) {
                    for (MutableShardRouting shardRouting : routingNode) {
                        if (!shardRouting.index().equals(index) || shardRouting.id() != i) continue;
                        shards.add(shardRouting);
                    }
                }
                List<MutableShardRouting> mutableShardRoutings = routingNodes.assignedShards(new ShardId(index, i));
                assert (mutableShardRoutings.size() == shards.size());
                for (MutableShardRouting r : mutableShardRoutings) {
                    assert (shards.contains(r));
                    shards.remove(r);
                }
                assert (shards.isEmpty());
            }
        }
        for (MutableShardRouting mutableShardRouting : routingNodes.unassigned()) {
            if (mutableShardRouting.primary()) {
                ++unassignedPrimaryCount;
            }
            seenShards.add(mutableShardRouting.shardId());
        }
        assert (unassignedPrimaryCount == routingNodes.unassignedShards.numPrimaries()) : "Unassigned primaries is [" + unassignedPrimaryCount + "] but RoutingNodes returned unassigned primaries [" + routingNodes.unassigned().numPrimaries() + "]";
        assert (inactivePrimaryCount == routingNodes.inactivePrimaryCount) : "Inactive Primary count [" + inactivePrimaryCount + "] but RoutingNodes returned inactive primaries [" + routingNodes.inactivePrimaryCount + "]";
        assert (inactiveShardCount == routingNodes.inactiveShardCount) : "Inactive Shard count [" + inactiveShardCount + "] but RoutingNodes returned inactive shards [" + routingNodes.inactiveShardCount + "]";
        assert (routingNodes.getRelocatingShardCount() == relocating) : "Relocating shards mismatch [" + routingNodes.getRelocatingShardCount() + "] but expected [" + relocating + "]";
        return true;
    }

    public final class RoutingNodeIterator
    implements Iterator<MutableShardRouting>,
    Iterable<MutableShardRouting> {
        private final RoutingNode iterable;
        private MutableShardRouting shard;
        private final Iterator<MutableShardRouting> delegate;

        public RoutingNodeIterator(RoutingNode iterable) {
            this.delegate = iterable.mutableIterator();
            this.iterable = iterable;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public MutableShardRouting next() {
            this.shard = this.delegate.next();
            return this.shard;
        }

        @Override
        public void remove() {
            this.delegate.remove();
            RoutingNodes.this.remove(this.shard);
        }

        @Override
        public Iterator<MutableShardRouting> iterator() {
            return this.iterable.iterator();
        }

        public void moveToUnassigned() {
            this.iterator().remove();
            RoutingNodes.this.unassigned().add(new MutableShardRouting(this.shard.index(), this.shard.id(), null, this.shard.primary(), ShardRoutingState.UNASSIGNED, this.shard.version() + 1L));
        }
    }

    public class RoutingNodesIterator
    implements Iterator<RoutingNode>,
    Iterable<MutableShardRouting> {
        private RoutingNode current;
        private final Iterator<RoutingNode> delegate;

        public RoutingNodesIterator(Iterator<RoutingNode> iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public RoutingNode next() {
            this.current = this.delegate.next();
            return this.current;
        }

        public RoutingNodeIterator nodeShards() {
            return new RoutingNodeIterator(this.current);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public Iterator<MutableShardRouting> iterator() {
            return this.nodeShards();
        }
    }

    public static final class UnassignedShards
    implements Iterable<MutableShardRouting> {
        private final List<MutableShardRouting> unassigned;
        private int primaries = 0;
        private long transactionId = 0L;
        private final UnassignedShards source;
        private final long sourceTransactionId;

        public UnassignedShards(UnassignedShards other) {
            this.source = other;
            this.sourceTransactionId = other.transactionId;
            this.unassigned = new ArrayList<MutableShardRouting>(other.unassigned);
            this.primaries = other.primaries;
        }

        public UnassignedShards() {
            this.unassigned = new ArrayList<MutableShardRouting>();
            this.source = null;
            this.sourceTransactionId = -1L;
        }

        public void add(MutableShardRouting mutableShardRouting) {
            if (mutableShardRouting.primary()) {
                ++this.primaries;
            }
            this.unassigned.add(mutableShardRouting);
            ++this.transactionId;
        }

        public void addAll(Collection<MutableShardRouting> mutableShardRoutings) {
            for (MutableShardRouting r : mutableShardRoutings) {
                this.add(r);
            }
        }

        public int size() {
            return this.unassigned.size();
        }

        public int numPrimaries() {
            return this.primaries;
        }

        @Override
        public Iterator<MutableShardRouting> iterator() {
            final Iterator<MutableShardRouting> iterator = this.unassigned.iterator();
            return new Iterator<MutableShardRouting>(){
                private MutableShardRouting current;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public MutableShardRouting next() {
                    this.current = (MutableShardRouting)iterator.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    if (this.current.primary()) {
                        UnassignedShards.this.primaries--;
                    }
                    UnassignedShards.this.transactionId++;
                }
            };
        }

        public boolean isEmpty() {
            return this.unassigned.isEmpty();
        }

        public void shuffle() {
            Collections.shuffle(this.unassigned);
        }

        public void clear() {
            ++this.transactionId;
            this.unassigned.clear();
            this.primaries = 0;
        }

        public void transactionEnd(UnassignedShards shards) {
            assert (shards.source == this && shards.sourceTransactionId == this.transactionId) : "Expected ID: " + shards.sourceTransactionId + " actual: " + this.transactionId + " Expected Source: " + shards.source + " actual: " + this;
            ++this.transactionId;
            this.unassigned.clear();
            this.unassigned.addAll(shards.unassigned);
            this.primaries = shards.primaries;
        }

        public UnassignedShards transactionBegin() {
            return new UnassignedShards(this);
        }

        public MutableShardRouting[] drain() {
            MutableShardRouting[] mutableShardRoutings = this.unassigned.toArray(new MutableShardRouting[this.unassigned.size()]);
            this.unassigned.clear();
            this.primaries = 0;
            ++this.transactionId;
            return mutableShardRoutings;
        }
    }
}

