/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Set;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class AllocationDeciders
extends AllocationDecider {
    private final AllocationDecider[] allocations;

    public AllocationDeciders(Settings settings, AllocationDecider[] allocations) {
        super(settings);
        this.allocations = allocations;
    }

    @Inject
    public AllocationDeciders(Settings settings, Set<AllocationDecider> allocations) {
        this(settings, allocations.toArray(new AllocationDecider[allocations.size()]));
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRebalance(shardRouting, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Can not allocate [{}] on node [{}] due to [{}]", shardRouting, node.nodeId(), allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (allocation.shouldIgnoreShardForNode(shardRouting.shardId(), node.nodeId())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Shard [{}] should be ignored for node [{}]", shardRouting, node.nodeId());
            }
            return Decision.NO;
        }
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canRemain(shardRouting, node, allocation);
            if (decision == Decision.NO) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Shard [{}] can not remain on node [{}] due to [{}]", shardRouting, node.nodeId(), allocationDecider.getClass().getSimpleName());
                }
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(shardRouting, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }

    @Override
    public Decision canAllocate(RoutingNode node, RoutingAllocation allocation) {
        Decision.Multi ret = new Decision.Multi();
        for (AllocationDecider allocationDecider : this.allocations) {
            Decision decision = allocationDecider.canAllocate(node, allocation);
            if (decision == Decision.NO) {
                if (!allocation.debugDecision()) {
                    return decision;
                }
                ret.add(decision);
                continue;
            }
            if (decision == Decision.ALWAYS) continue;
            ret.add(decision);
        }
        return ret;
    }
}

